/*
 * Decompiled with CFR 0.152.
 */
package dev.protomanly.pmweather.particle;

import dev.protomanly.pmweather.PMWeather;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.client.renderer.texture.atlas.sources.SingleFile;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.TextureAtlasStitchedEvent;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.common.data.SpriteSourceProvider;

public class ParticleRegistry
extends SpriteSourceProvider {
    public static TextureAtlasSprite rain;
    public static TextureAtlasSprite splash;
    public static TextureAtlasSprite snow;

    public ParticleRegistry(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, String modId, ExistingFileHelper existingFileHelper) {
        super(output, lookupProvider, modId, existingFileHelper);
    }

    protected void gather() {
        this.addSprite(PMWeather.getPath("particle/rain"));
        this.addSprite(PMWeather.getPath("particle/splash"));
        this.addSprite(PMWeather.getPath("particle/snow"));
    }

    public void addSprite(ResourceLocation resourceLocation) {
        this.atlas(SpriteSourceProvider.PARTICLES_ATLAS).addSource((SpriteSource)new SingleFile(resourceLocation, Optional.empty()));
    }

    @EventBusSubscriber(modid="pmweather", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class Events {
        @SubscribeEvent
        public static void getRegisteredParticles(TextureAtlasStitchedEvent event) {
            if (!event.getAtlas().location().equals((Object)TextureAtlas.LOCATION_PARTICLES)) {
                return;
            }
            rain = event.getAtlas().getSprite(PMWeather.getPath("particle/rain"));
            snow = event.getAtlas().getSprite(PMWeather.getPath("particle/snow"));
            splash = event.getAtlas().getSprite(PMWeather.getPath("particle/splash"));
        }
    }
}

