/*
 * Decompiled with CFR 0.152.
 */
package dev.protomanly.pmweather.weather;

import dev.protomanly.pmweather.compat.SereneSeasons;
import dev.protomanly.pmweather.config.ServerConfig;
import dev.protomanly.pmweather.util.Util;
import dev.protomanly.pmweather.weather.Storm;
import dev.protomanly.pmweather.weather.WeatherHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.synth.SimplexNoise;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class WeatherProperties {
    public static SimplexNoise noise = new SimplexNoise((RandomSource)new LegacyRandomSource(0L));

    public static double FBM(Vec3 pos, int octaves, float lacunarity, float gain, float amplitude) {
        double y = 0.0;
        for (int i = 0; i < Math.max(octaves, 1); ++i) {
            y += (double)amplitude * noise.getValue(pos.x, pos.y, pos.z);
            pos = pos.multiply((double)lacunarity, (double)lacunarity, (double)lacunarity);
            amplitude *= gain;
        }
        return y;
    }

    public static Properties getTemperature(WeatherHandler weatherHandler, Level level, Vec3 pos, int advance) {
        BlockPos blockPos = new BlockPos((int)pos.x, (int)pos.y, (int)pos.z);
        Holder biome = level.getBiome(blockPos);
        float biomeTemp = SereneSeasons.getBiomeTemperature(level, (Holder<Biome>)biome, blockPos) - 0.15f;
        float temp = biomeTemp <= 0.0f ? Mth.lerp((float)(-biomeTemp), (float)0.0f, (float)-20.0f) : Mth.lerp((float)((float)Math.pow((double)biomeTemp / 1.85, 0.5)), (float)0.0f, (float)35.0f);
        if (pos.y > 75.0) {
            temp -= ((float)pos.y - 75.0f) / 10.0f;
        }
        float time = level.getGameTime() + (long)advance;
        float daytime = (float)(level.getDayTime() + (long)advance) / 24000.0f;
        double x = ((double)daytime - 0.18) * Math.PI * 2.0;
        double timeFactor = Math.sin(x + Math.sin(x) / -2.0);
        float humidity = ((Biome)biome.value()).getModifiedClimateSettings().downfall();
        temp += humidity * 3.0f;
        temp += (float)timeFactor * 10.0f * Math.max(1.0f - humidity, 0.05f);
        temp += (float)noise.getValue(pos.x / 2400.0, (double)(time / 9000.0f) + pos.y / 100.0, pos.z / 2400.0) * 2.0f;
        temp += (float)noise.getValue(pos.x / 300.0, (double)(time / 5000.0f) + pos.y / 50.0, pos.z / 300.0) * 0.5f;
        for (Storm storm : weatherHandler.getStorms()) {
            float start;
            if (storm.stormType != 1) continue;
            double distance = pos.multiply(1.0, 0.0, 1.0).distanceTo(storm.position.multiply(1.0, 0.0, 1.0));
            Vec2 v2fWorldPos = new Vec2((float)pos.x, (float)pos.z);
            Vec2 stormVel = new Vec2((float)storm.velocity.x, (float)storm.velocity.z);
            Vec2 v2fStormPos = new Vec2((float)storm.position.x, (float)storm.position.z);
            Vec2 right = new Vec2(stormVel.y, -stormVel.x).normalized();
            Vec2 fwd = stormVel.normalized();
            Vec2 le = Util.mulVec2(right, -((float)ServerConfig.stormSize) * 5.0f);
            Vec2 ri = Util.mulVec2(right, (float)ServerConfig.stormSize * 5.0f);
            Vec2 off = Util.mulVec2(fwd, -((float)Math.pow(Mth.clamp((double)(distance / (double)((float)ServerConfig.stormSize * 5.0f)), (double)0.0, (double)1.0), 2.0)) * ((float)ServerConfig.stormSize * 1.5f));
            le = le.add(off);
            ri = ri.add(off);
            le = le.add(v2fStormPos);
            ri = ri.add(v2fStormPos);
            float d = Util.minimumDistance(le, ri, v2fWorldPos);
            Vec2 nearPoint = Util.nearestPoint(le, ri, v2fWorldPos);
            Vec2 facing = v2fWorldPos.add(nearPoint.negated());
            float behind = -facing.dot(fwd);
            behind += (float)WeatherProperties.FBM(new Vec3(pos.x / (ServerConfig.stormSize * 2.0), pos.z / (ServerConfig.stormSize * 2.0), (double)((float)level.getGameTime() / 20000.0f)), 5, 2.0f, 0.2f, 1.0f) * (float)ServerConfig.stormSize * 0.25f;
            behind += (float)ServerConfig.stormSize;
            float sze = (float)ServerConfig.stormSize * 12.0f;
            if (!(behind > 0.0f)) continue;
            float p = Mth.clamp((float)(Math.abs(behind) / sze), (float)0.0f, (float)1.0f);
            p = p <= (start = 0.02f) ? (p /= start) : 1.0f - (p - start) / (1.0f - start);
            temp -= Mth.clamp((float)p, (float)0.0f, (float)1.0f) * 12.0f * (float)Math.pow((float)storm.coldEnergy / (float)storm.maxColdEnergy, 0.75);
        }
        float dewP = Mth.clamp((float)((float)Mth.lerp((double)0.7, (double)((noise.getValue(pos.z / 2200.0, (double)(time / 9000.0f) + pos.y / 100.0, pos.x / 300.0) + 1.0) / 2.0), (double)Math.pow(humidity, 0.5))), (float)0.2f, (float)1.0f);
        float dew = temp - Math.clamp((1.0f - dewP) * temp, 0.0f, 4.0f);
        dew -= ((float)noise.getValue(pos.z / 2400.0, (double)(time / 9000.0f) + pos.y / 50.0, pos.x / 2400.0) + 1.0f) * 0.5f * Mth.lerp((float)humidity, (float)5.0f, (float)1.0f);
        float risk = Math.clamp((temp - (dew *= (float)Math.pow(humidity, 0.5) * 0.5f + 0.5f)) / 8.0f, 0.3f, 1.3f);
        risk *= Math.clamp(temp / 22.0f, 0.0f, 1.5f);
        risk *= Math.clamp(dew / 18.0f, 0.0f, 1.5f);
        risk *= 1.0f - Math.clamp((temp - 35.0f) / 10.0f, 0.0f, 1.0f);
        risk /= 1.25f;
        float n = (float)noise.getValue(pos.z / 9000.0, (double)(time / 12000.0f) + pos.y / 1000.0, pos.x / 9000.0);
        return new Properties(temp, dew, Math.clamp(risk += (float)Math.pow((n + 1.0f) / 2.0f, 2.0) - 0.3f, 0.0f, 1.75f));
    }

    public static Properties getTemperature(WeatherHandler weatherHandler, Level level, Vec3 pos) {
        return WeatherProperties.getTemperature(weatherHandler, level, pos, 0);
    }

    public static Properties getTemperature(WeatherHandler weatherHandler, Level level, BlockPos pos, int advance) {
        return WeatherProperties.getTemperature(weatherHandler, level, pos.getCenter(), advance);
    }

    public static Properties getTemperature(WeatherHandler weatherHandler, Level level, BlockPos pos) {
        return WeatherProperties.getTemperature(weatherHandler, level, pos.getCenter(), 0);
    }

    public record Properties(float temperature, float dewpoint, float risk) {
    }
}

