/*
 * Decompiled with CFR 0.152.
 */
package me.tuplugin.privatechest;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import me.tuplugin.privatechest.ChestLocker;
import me.tuplugin.privatechest.DataManager;
import me.tuplugin.privatechest.PrivateChest;
import me.tuplugin.privatechest.TrustManager;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class AutoCleanupManager {
    private final PrivateChest plugin;
    private final ChestLocker chestLocker;
    private final DataManager dataManager;
    private final TrustManager trustManager;
    private BukkitTask periodicCleanupTask;
    private static final long STARTUP_CLEANUP_DELAY_TICKS = 200L;
    private static final long PERIODIC_CLEANUP_INTERVAL_MINUTES = 30L;
    private static final int MAX_CLEANUP_PER_CYCLE = 50;

    public AutoCleanupManager(PrivateChest plugin) {
        this.plugin = plugin;
        this.chestLocker = plugin.getChestLocker();
        this.dataManager = plugin.getDataManager();
        this.trustManager = plugin.getTrustManager();
    }

    public void initialize() {
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.performCleanup(CleanupType.STARTUP), 200L);
        if (this.isPeriodicCleanupEnabled()) {
            long intervalTicks = 36000L;
            this.periodicCleanupTask = new BukkitRunnable(){

                public void run() {
                    AutoCleanupManager.this.performCleanup(CleanupType.PERIODIC);
                }
            }.runTaskTimerAsynchronously((Plugin)this.plugin, intervalTicks, intervalTicks);
            this.plugin.getLogger().info("[AutoCleanup] Periodic cleanup scheduled every 30 minutes");
        }
    }

    public void shutdown() {
        if (this.periodicCleanupTask != null && !this.periodicCleanupTask.isCancelled()) {
            this.periodicCleanupTask.cancel();
            this.periodicCleanupTask = null;
        }
    }

    public void performCleanup(CleanupType cleanupType) {
        long startTime = System.currentTimeMillis();
        AtomicInteger cleanedContainers = new AtomicInteger(0);
        AtomicInteger cleanedTrustRelations = new AtomicInteger(0);
        this.plugin.getLogger().info("[AutoCleanup] Starting " + cleanupType.name().toLowerCase() + " cleanup of orphaned data...");
        this.cleanupOrphanedContainers(cleanedContainers, cleanupType);
        this.cleanupOrphanedTrustRelations(cleanedTrustRelations);
        if (cleanedContainers.get() > 0 || cleanedTrustRelations.get() > 0) {
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.dataManager.saveData());
        }
        long duration = System.currentTimeMillis() - startTime;
        if (cleanedContainers.get() > 0 || cleanedTrustRelations.get() > 0) {
            this.plugin.getLogger().info(String.format("[AutoCleanup] %s cleanup completed in %dms: %d containers, %d trust relations cleaned", cleanupType.name().toLowerCase(), duration, cleanedContainers.get(), cleanedTrustRelations.get()));
        } else {
            this.plugin.getLogger().fine(String.format("[AutoCleanup] %s cleanup completed in %dms: No orphaned data found", cleanupType.name().toLowerCase(), duration));
        }
    }

    private void cleanupOrphanedContainers(AtomicInteger cleanedCounter, CleanupType cleanupType) {
        Map<Location, String> owners = this.chestLocker.getChestOwners();
        Map<Location, String> passwords = this.chestLocker.getChestPasswords();
        int maxToProcess = cleanupType == CleanupType.STARTUP ? Integer.MAX_VALUE : 50;
        Iterator<Map.Entry<Location, String>> it = owners.entrySet().iterator();
        for (int processed = 0; it.hasNext() && processed < maxToProcess; ++processed) {
            Map.Entry<Location, String> entry = it.next();
            Location loc = entry.getKey();
            if (!this.isOrphanedContainer(loc)) continue;
            passwords.remove(loc);
            it.remove();
            cleanedCounter.incrementAndGet();
            this.plugin.getLogger().fine(String.format("[AutoCleanup] Removed orphaned container at %s:%d,%d,%d", loc.getWorld() != null ? loc.getWorld().getName() : "null", loc.getBlockX(), loc.getBlockY(), loc.getBlockZ()));
        }
    }

    private void cleanupOrphanedTrustRelations(AtomicInteger cleanedCounter) {
        Map<String, String> owners = this.chestLocker.getChestOwners().entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getValue(), entry -> (String)entry.getValue(), (existing, replacement) -> existing));
        Map<String, Set<String>> allTrustRelations = this.trustManager.getAllTrustRelations();
        Iterator<Map.Entry<String, Set<String>>> it = allTrustRelations.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Set<String>> entry2 = it.next();
            String ownerUUID = entry2.getKey();
            if (owners.containsKey(ownerUUID)) continue;
            it.remove();
            cleanedCounter.addAndGet(entry2.getValue().size());
            this.plugin.getLogger().fine(String.format("[AutoCleanup] Removed trust relations for player UUID %s (no longer owns containers)", ownerUUID));
        }
    }

    private boolean isOrphanedContainer(Location loc) {
        if (loc.getWorld() == null) {
            return true;
        }
        if (!loc.getWorld().isChunkLoaded(loc.getBlockX() >> 4, loc.getBlockZ() >> 4)) {
            return false;
        }
        Block block = loc.getBlock();
        return !this.isLockableContainer(block);
    }

    private boolean isLockableContainer(Block block) {
        if (block == null) {
            return false;
        }
        Material type = block.getType();
        if (type == Material.CHEST || type == Material.TRAPPED_CHEST || type == Material.BARREL) {
            return true;
        }
        String typeName = type.name();
        return typeName.contains("SHULKER_BOX");
    }

    private boolean isPeriodicCleanupEnabled() {
        return this.plugin.getConfig().getBoolean("auto-cleanup.periodic-enabled", true);
    }

    public CleanupReport performImmediateCleanup() {
        long startTime = System.currentTimeMillis();
        AtomicInteger cleanedContainers = new AtomicInteger(0);
        AtomicInteger cleanedTrustRelations = new AtomicInteger(0);
        this.cleanupOrphanedContainers(cleanedContainers, CleanupType.MANUAL);
        this.cleanupOrphanedTrustRelations(cleanedTrustRelations);
        if (cleanedContainers.get() > 0 || cleanedTrustRelations.get() > 0) {
            this.dataManager.saveData();
        }
        long duration = System.currentTimeMillis() - startTime;
        return new CleanupReport(cleanedContainers.get(), cleanedTrustRelations.get(), duration);
    }

    public static enum CleanupType {
        STARTUP,
        PERIODIC,
        MANUAL;

    }

    public static class CleanupReport {
        private final int cleanedContainers;
        private final int cleanedTrustRelations;
        private final long durationMs;

        public CleanupReport(int cleanedContainers, int cleanedTrustRelations, long durationMs) {
            this.cleanedContainers = cleanedContainers;
            this.cleanedTrustRelations = cleanedTrustRelations;
            this.durationMs = durationMs;
        }

        public int getCleanedContainers() {
            return this.cleanedContainers;
        }

        public int getCleanedTrustRelations() {
            return this.cleanedTrustRelations;
        }

        public long getDurationMs() {
            return this.durationMs;
        }

        public int getTotalCleaned() {
            return this.cleanedContainers + this.cleanedTrustRelations;
        }

        public String toString() {
            return String.format("CleanupReport{containers=%d, trustRelations=%d, duration=%dms}", this.cleanedContainers, this.cleanedTrustRelations, this.durationMs);
        }
    }
}

