/*
 * Decompiled with CFR 0.152.
 */
package me.tuplugin.privatechest;

import java.util.UUID;
import java.util.regex.Pattern;
import me.tuplugin.privatechest.PrivateChest;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class BedrockUtils {
    private final PrivateChest plugin;
    private static boolean floodgateEnabled = false;
    private static boolean floodgateChecked = false;
    private static final String FLOODGATE_PREFIX = "00000000-0000-0000-0009-";
    private static final Pattern BEDROCK_UUID_PATTERN = Pattern.compile("^00000000-0000-0000-0009-[0-9a-fA-F]{12}$");
    private static final Pattern BEDROCK_SAFE_CHARS = Pattern.compile("^[a-zA-Z0-9\\s\\-_\\.]+$");
    private static final int BEDROCK_MAX_MESSAGE_LENGTH = 100;

    public BedrockUtils(PrivateChest plugin) {
        this.plugin = plugin;
        this.checkFloodgateAvailability();
    }

    private void checkFloodgateAvailability() {
        if (floodgateChecked) {
            return;
        }
        try {
            if (Bukkit.getPluginManager().getPlugin("floodgate") != null) {
                Class.forName("org.geysermc.floodgate.api.FloodgateApi");
                floodgateEnabled = true;
                this.plugin.getLogger().info("[BedrockUtils] Floodgate detected - Bedrock Edition support enabled");
            } else {
                floodgateEnabled = false;
                this.plugin.getLogger().info("[BedrockUtils] Floodgate not detected - Java Edition only mode");
            }
        }
        catch (ClassNotFoundException e) {
            floodgateEnabled = false;
            this.plugin.getLogger().warning("[BedrockUtils] Floodgate plugin found but API not available");
        }
        catch (Exception e) {
            floodgateEnabled = false;
            this.plugin.getLogger().warning("[BedrockUtils] Error checking Floodgate availability: " + e.getMessage());
        }
        floodgateChecked = true;
    }

    public boolean isBedrockPlayer(Player player) {
        if (player == null) {
            return false;
        }
        return this.isBedrockPlayer(player.getUniqueId());
    }

    public boolean isBedrockPlayer(UUID playerUUID) {
        if (playerUUID == null) {
            return false;
        }
        if (floodgateEnabled) {
            try {
                Class<?> apiClass = Class.forName("org.geysermc.floodgate.api.FloodgateApi");
                Object api = apiClass.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
                return (Boolean)apiClass.getMethod("isFloodgatePlayer", UUID.class).invoke(api, playerUUID);
            }
            catch (Exception e) {
                this.plugin.getLogger().fine("[BedrockUtils] Floodgate API error, falling back to pattern matching: " + e.getMessage());
            }
        }
        return this.isBedrockUUID(playerUUID.toString());
    }

    public boolean isBedrockUUID(String uuid) {
        if (uuid == null || uuid.isEmpty()) {
            return false;
        }
        return BEDROCK_UUID_PATTERN.matcher(uuid).matches();
    }

    public String getBedrockUsername(Player player) {
        if (!this.isBedrockPlayer(player)) {
            return player.getName();
        }
        if (floodgateEnabled) {
            try {
                Class<?> apiClass = Class.forName("org.geysermc.floodgate.api.FloodgateApi");
                Object api = apiClass.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
                Object floodgatePlayer = apiClass.getMethod("getPlayer", UUID.class).invoke(api, player.getUniqueId());
                if (floodgatePlayer != null) {
                    return (String)floodgatePlayer.getClass().getMethod("getCorrectUsername", new Class[0]).invoke(floodgatePlayer, new Object[0]);
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().fine("[BedrockUtils] Error getting Bedrock username: " + e.getMessage());
            }
        }
        return player.getName();
    }

    public String adaptMessageForBedrock(String message, boolean isBedrockPlayer) {
        if (!isBedrockPlayer || message == null) {
            return message;
        }
        String adapted = message;
        adapted = adapted.replace("\u00a7k", "");
        adapted = adapted.replace("\u00a7l", "");
        adapted = adapted.replace("\u00a7m", "");
        adapted = adapted.replace("\u00a7n", "");
        if ((adapted = adapted.replace("\u00a7o", "")).length() > 100) {
            adapted = adapted.substring(0, 97) + "...";
        }
        adapted = adapted.replace("\u2705", "[OK]");
        adapted = adapted.replace("\u274c", "[X]");
        adapted = adapted.replace("\u26a0", "[!]");
        adapted = adapted.replace("\u25b6", ">");
        adapted = adapted.replace("\u25c0", "<");
        return adapted;
    }

    public boolean isBedrockSafeName(String name) {
        if (name == null || name.trim().isEmpty()) {
            return false;
        }
        String trimmed = name.trim();
        if (!BEDROCK_SAFE_CHARS.matcher(trimmed).matches()) {
            return false;
        }
        return trimmed.length() <= 12;
    }

    public String getPlayerPlatform(Player player) {
        if (this.isBedrockPlayer(player)) {
            return "Bedrock";
        }
        return "Java";
    }

    public static boolean isFloodgateAvailable() {
        return floodgateEnabled;
    }

    public String getPlatformStatistics() {
        int javaPlayers = 0;
        int bedrockPlayers = 0;
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (this.isBedrockPlayer(player)) {
                ++bedrockPlayers;
                continue;
            }
            ++javaPlayers;
        }
        return String.format("Java: %d, Bedrock: %d, Total: %d", javaPlayers, bedrockPlayers, javaPlayers + bedrockPlayers);
    }

    public void logPlatformInfo(Player player, String action) {
        if (this.plugin.getConfig().getBoolean("debug.log-platform-info", false)) {
            String platform = this.getPlayerPlatform(player);
            this.plugin.getLogger().info(String.format("[Platform] %s (%s) performed: %s", player.getName(), platform, action));
        }
    }
}

