/*
 * Decompiled with CFR 0.152.
 */
package me.tuplugin.privatechest;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import me.tuplugin.privatechest.ChestLocker;
import me.tuplugin.privatechest.MessageManager;
import me.tuplugin.privatechest.PrivateChest;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Chest;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.entity.EntityExplodeEvent;

public class BlockProtectionListener
implements Listener {
    private final PrivateChest plugin;
    private final ChestLocker chestLocker;
    private final MessageManager messages;

    public BlockProtectionListener(PrivateChest plugin) {
        this.plugin = plugin;
        this.chestLocker = ChestLocker.getInstance();
        this.messages = plugin.getMessageManager();
    }

    @EventHandler
    public void onChestBreak(BlockBreakEvent event) {
        Block blockBeingBroken = event.getBlock();
        Player player = event.getPlayer();
        if (!this.isLockableContainer(blockBeingBroken.getType())) {
            return;
        }
        Set<Block> containerBlocks = this.getContainerBlocks(blockBeingBroken);
        Block lockedBlock = null;
        for (Block part : containerBlocks) {
            if (!this.chestLocker.isChestLocked(part)) continue;
            lockedBlock = part;
            break;
        }
        if (lockedBlock == null) {
            return;
        }
        if (!this.chestLocker.isOwner(lockedBlock, player) && !player.hasPermission("privatechest.admin")) {
            event.setCancelled(true);
            player.sendMessage(this.messages.get("not_your_chest"));
        } else {
            if (this.chestLocker.isOwner(lockedBlock, player)) {
                player.sendMessage(this.messages.get("chest_break_warning"));
            } else {
                player.sendMessage(this.messages.get("admin_chest_break_notice"));
            }
            for (Block part : containerBlocks) {
                if (!this.chestLocker.isChestLocked(part)) continue;
                this.chestLocker.removeProtection(part);
            }
            this.plugin.getDataManager().saveData();
        }
    }

    @EventHandler
    public void onEntityExplode(EntityExplodeEvent event) {
        Iterator it = event.blockList().iterator();
        while (it.hasNext()) {
            Block block = (Block)it.next();
            if (!this.isLockableContainer(block.getType()) || !this.chestLocker.isChestLocked(block)) continue;
            it.remove();
        }
    }

    @EventHandler
    public void onBlockExplode(BlockExplodeEvent event) {
        Iterator it = event.blockList().iterator();
        while (it.hasNext()) {
            Block block = (Block)it.next();
            if (!this.isLockableContainer(block.getType()) || !this.chestLocker.isChestLocked(block)) continue;
            it.remove();
        }
    }

    private Set<Block> getContainerBlocks(Block block) {
        Block otherBlock;
        BlockFace facing;
        BlockFace otherHalfDirection;
        Chest chestData;
        Chest.Type chestType;
        HashSet<Block> blocks = new HashSet<Block>();
        blocks.add(block);
        BlockState state = block.getState();
        BlockData blockData = block.getBlockData();
        if (state instanceof org.bukkit.block.Chest && blockData instanceof Chest && (chestType = (chestData = (Chest)blockData).getType()) != Chest.Type.SINGLE && (otherHalfDirection = this.getOtherChestHalfDirection(chestType, facing = chestData.getFacing())) != null && (otherBlock = block.getRelative(otherHalfDirection)).getState() instanceof org.bukkit.block.Chest) {
            blocks.add(otherBlock);
        }
        return blocks;
    }

    private BlockFace getOtherChestHalfDirection(Chest.Type type, BlockFace facing) {
        if (type == Chest.Type.LEFT) {
            switch (facing) {
                case NORTH: {
                    return BlockFace.EAST;
                }
                case EAST: {
                    return BlockFace.SOUTH;
                }
                case SOUTH: {
                    return BlockFace.WEST;
                }
                case WEST: {
                    return BlockFace.NORTH;
                }
            }
            return null;
        }
        if (type == Chest.Type.RIGHT) {
            switch (facing) {
                case NORTH: {
                    return BlockFace.WEST;
                }
                case EAST: {
                    return BlockFace.NORTH;
                }
                case SOUTH: {
                    return BlockFace.EAST;
                }
                case WEST: {
                    return BlockFace.SOUTH;
                }
            }
            return null;
        }
        return null;
    }

    private boolean isLockableContainer(Material type) {
        return type == Material.CHEST || type == Material.TRAPPED_CHEST || type == Material.BARREL;
    }
}

