/*
 * Decompiled with CFR 0.152.
 */
package me.tuplugin.privatechest;

import java.util.HashSet;
import java.util.Set;
import me.tuplugin.privatechest.ChestLocker;
import me.tuplugin.privatechest.MessageManager;
import me.tuplugin.privatechest.PrivateChest;
import me.tuplugin.privatechest.TrustManager;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Chest;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;

public class ChestListener
implements Listener {
    private final PrivateChest plugin;
    private final ChestLocker chestLocker;
    private final TrustManager trustManager;
    private final MessageManager messages;
    private final FileConfiguration config;

    public ChestListener(PrivateChest plugin) {
        this.plugin = plugin;
        this.chestLocker = ChestLocker.getInstance();
        this.trustManager = TrustManager.getInstance();
        this.messages = plugin.getMessageManager();
        this.config = plugin.getConfig();
    }

    @EventHandler
    public void onChestInteract(PlayerInteractEvent event) {
        if (event.getClickedBlock() == null || event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block clickedBlock = event.getClickedBlock();
        Player player = event.getPlayer();
        if (!this.isLockableContainer(clickedBlock.getType())) {
            return;
        }
        Set<Block> containerBlocks = this.getContainerBlocks(clickedBlock);
        Block lockedBlock = null;
        for (Block part : containerBlocks) {
            if (!this.chestLocker.isChestLocked(part)) continue;
            lockedBlock = part;
            break;
        }
        if (lockedBlock == null) {
            return;
        }
        if (this.chestLocker.isOwner(lockedBlock, player)) {
            if (this.config.getBoolean("notify-owner-on-open", true)) {
                player.sendMessage(this.messages.get("owner_access_notice"));
            }
            return;
        }
        if (player.hasPermission("privatechest.admin")) {
            if (this.config.getBoolean("notify-admin-on-open", true)) {
                player.sendMessage(this.messages.get("admin_access_notice"));
            }
            return;
        }
        String ownerUUID = this.chestLocker.getOwnerUUID(lockedBlock);
        if (ownerUUID != null && this.trustManager.isTrusted(ownerUUID, player.getUniqueId().toString())) {
            if (this.config.getBoolean("notify-trusted-on-open", true)) {
                player.sendMessage(this.messages.get("trusted_access_notice"));
            }
            return;
        }
        event.setCancelled(true);
        player.sendMessage(this.messages.get("not_your_chest"));
    }

    private Set<Block> getContainerBlocks(Block block) {
        Block otherBlock;
        BlockFace facing;
        BlockFace otherHalfDirection;
        Chest chestData;
        Chest.Type chestType;
        HashSet<Block> blocks = new HashSet<Block>();
        blocks.add(block);
        BlockState state = block.getState();
        BlockData blockData = block.getBlockData();
        if (state instanceof org.bukkit.block.Chest && blockData instanceof Chest && (chestType = (chestData = (Chest)blockData).getType()) != Chest.Type.SINGLE && (otherHalfDirection = this.getOtherChestHalfDirection(chestType, facing = chestData.getFacing())) != null && (otherBlock = block.getRelative(otherHalfDirection)).getState() instanceof org.bukkit.block.Chest) {
            blocks.add(otherBlock);
        }
        return blocks;
    }

    private BlockFace getOtherChestHalfDirection(Chest.Type type, BlockFace facing) {
        if (type == Chest.Type.LEFT) {
            switch (facing) {
                case NORTH: {
                    return BlockFace.EAST;
                }
                case EAST: {
                    return BlockFace.SOUTH;
                }
                case SOUTH: {
                    return BlockFace.WEST;
                }
                case WEST: {
                    return BlockFace.NORTH;
                }
            }
            return null;
        }
        if (type == Chest.Type.RIGHT) {
            switch (facing) {
                case NORTH: {
                    return BlockFace.WEST;
                }
                case EAST: {
                    return BlockFace.NORTH;
                }
                case SOUTH: {
                    return BlockFace.EAST;
                }
                case WEST: {
                    return BlockFace.SOUTH;
                }
            }
            return null;
        }
        return null;
    }

    private boolean isLockableContainer(Material type) {
        return type == Material.CHEST || type == Material.TRAPPED_CHEST || type == Material.BARREL;
    }
}

