/*
 * Decompiled with CFR 0.152.
 */
package me.tuplugin.privatechest;

import java.util.HashMap;
import java.util.Map;
import me.tuplugin.privatechest.PasswordManager;
import me.tuplugin.privatechest.PrivateChest;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class ChestLocker {
    private final Map<Location, String> chestOwners = new HashMap<Location, String>();
    private final Map<Location, String> chestPasswords = new HashMap<Location, String>();
    private static ChestLocker instance;
    private final PrivateChest plugin;

    public ChestLocker(PrivateChest plugin) {
        this.plugin = plugin;
        instance = this;
    }

    public static ChestLocker getInstance() {
        return instance;
    }

    public boolean lockChest(Block block, Player player, String password) {
        Location loc = block.getLocation();
        if (this.chestOwners.containsKey(loc)) {
            return false;
        }
        String hashedPassword = PasswordManager.hashPassword(password);
        if (hashedPassword == null) {
            this.plugin.getLogger().warning("Failed to hash password for chest at " + ChestLocker.serializeLocation(loc) + ". Using plain text as fallback.");
            hashedPassword = password;
        }
        this.chestOwners.put(loc, player.getUniqueId().toString());
        this.chestPasswords.put(loc, hashedPassword);
        return true;
    }

    public boolean unlockChest(Block block, Player player, String password) {
        Location loc = block.getLocation();
        if (!this.chestOwners.containsKey(loc)) {
            return false;
        }
        String storedPassword = this.chestPasswords.get(loc);
        if (storedPassword == null) {
            return false;
        }
        if (PasswordManager.isPlainText(storedPassword)) {
            boolean isCorrect = storedPassword.equals(password);
            if (isCorrect) {
                String hashedPassword = PasswordManager.migratePlainPassword(password);
                if (hashedPassword != null) {
                    this.chestPasswords.put(loc, hashedPassword);
                    this.plugin.getLogger().info("Migrated plain text password to hashed format for chest at " + ChestLocker.serializeLocation(loc));
                    this.plugin.getDataManager().saveData();
                } else {
                    this.plugin.getLogger().warning("Failed to migrate password for chest at " + ChestLocker.serializeLocation(loc));
                }
            }
            return isCorrect;
        }
        return PasswordManager.verifyPassword(password, storedPassword);
    }

    public boolean isChestLocked(Block block) {
        return this.chestOwners.containsKey(block.getLocation());
    }

    public boolean isOwner(Block block, Player player) {
        String ownerUUID = this.chestOwners.get(block.getLocation());
        return ownerUUID != null && ownerUUID.equals(player.getUniqueId().toString());
    }

    public String getOwnerUUID(Block block) {
        return this.chestOwners.get(block.getLocation());
    }

    public void removeProtection(Block block) {
        Location loc = block.getLocation();
        this.chestOwners.remove(loc);
        this.chestPasswords.remove(loc);
    }

    public Map<Location, String> getChestOwners() {
        return this.chestOwners;
    }

    public Map<Location, String> getChestPasswords() {
        return this.chestPasswords;
    }

    public void migrateAllPasswords() {
        int migrated = 0;
        boolean dataChanged = false;
        for (Map.Entry<Location, String> entry : this.chestPasswords.entrySet()) {
            String currentPassword = entry.getValue();
            if (!PasswordManager.isPlainText(currentPassword)) continue;
            String hashedPassword = PasswordManager.migratePlainPassword(currentPassword);
            if (hashedPassword != null) {
                entry.setValue(hashedPassword);
                ++migrated;
                dataChanged = true;
                continue;
            }
            this.plugin.getLogger().warning("Failed to migrate password for chest at " + ChestLocker.serializeLocation(entry.getKey()));
        }
        if (dataChanged) {
            this.plugin.getDataManager().saveData();
            this.plugin.getLogger().info("Successfully migrated " + migrated + " plain text passwords to hashed format.");
        }
    }

    public static String serializeLocation(Location loc) {
        return loc.getWorld().getName() + ":" + loc.getBlockX() + ":" + loc.getBlockY() + ":" + loc.getBlockZ();
    }

    public static Location deserializeLocation(String serialized) {
        String[] parts = serialized.split(":");
        if (parts.length != 4) {
            return null;
        }
        World world = Bukkit.getWorld((String)parts[0]);
        if (world == null) {
            return null;
        }
        try {
            int x = Integer.parseInt(parts[1]);
            int y = Integer.parseInt(parts[2]);
            int z = Integer.parseInt(parts[3]);
            return new Location(world, (double)x, (double)y, (double)z);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

