/*
 * Decompiled with CFR 0.152.
 */
package me.tuplugin.privatechest;

import java.util.Iterator;
import java.util.Map;
import me.tuplugin.privatechest.ChestLocker;
import me.tuplugin.privatechest.DataManager;
import me.tuplugin.privatechest.MessageManager;
import me.tuplugin.privatechest.PrivateChest;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class ClearChestsCommand
implements CommandExecutor {
    private final PrivateChest plugin;
    private final DataManager dataManager;
    private final ChestLocker chestLocker;
    private final MessageManager messages;

    public ClearChestsCommand(PrivateChest plugin) {
        this.plugin = plugin;
        this.dataManager = plugin.getDataManager();
        this.chestLocker = ChestLocker.getInstance();
        this.messages = plugin.getMessageManager();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("privatechest.admin")) {
            sender.sendMessage(this.messages.raw("no_permission"));
            return true;
        }
        sender.sendMessage(this.messages.raw("cleaning_start"));
        int cleared = 0;
        Map<Location, String> owners = this.chestLocker.getChestOwners();
        Map<Location, String> passwords = this.chestLocker.getChestPasswords();
        Iterator<Map.Entry<Location, String>> it = owners.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Location, String> entry = it.next();
            Location loc = entry.getKey();
            if (loc.getWorld() == null) {
                passwords.remove(loc);
                it.remove();
                ++cleared;
                continue;
            }
            Block block = loc.getBlock();
            if (this.isLockableContainer(block)) continue;
            passwords.remove(loc);
            it.remove();
            ++cleared;
        }
        if (cleared > 0) {
            this.dataManager.saveData();
            sender.sendMessage(this.messages.raw("cleaned_chests").replace("{amount}", String.valueOf(cleared)));
        } else {
            sender.sendMessage(this.messages.raw("no_chests_to_clean"));
        }
        return true;
    }

    private boolean isLockableContainer(Block block) {
        if (block == null) {
            return false;
        }
        Material type = block.getType();
        return type == Material.CHEST || type == Material.TRAPPED_CHEST || type == Material.BARREL;
    }
}

