/*
 * Decompiled with CFR 0.152.
 */
package me.tuplugin.privatechest;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import me.tuplugin.privatechest.ChestLocker;
import me.tuplugin.privatechest.PrivateChest;
import me.tuplugin.privatechest.enums.ContainerType;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ContainerNameManager {
    private final PrivateChest plugin;
    private final ChestLocker chestLocker;
    private final Map<Location, String> containerNames;
    private static final int MAX_NAME_LENGTH = 16;
    private static final int MIN_NAME_LENGTH = 1;
    private static final Pattern VALID_NAME_PATTERN = Pattern.compile("^[a-zA-Z0-9_\\-\\s]+$");
    private static final String[] FORBIDDEN_NAMES = new String[]{"null", "undefined", "admin", "console", "system", "server", "privatechest", "chest", "container", "locked", "protected"};

    public ContainerNameManager(PrivateChest plugin) {
        this.plugin = plugin;
        this.chestLocker = plugin.getChestLocker();
        this.containerNames = new ConcurrentHashMap<Location, String>();
    }

    public NameResult setContainerName(Location location, Player player, String name) {
        Block block = location.getBlock();
        if (!this.chestLocker.isChestLocked(block)) {
            return new NameResult(false, "container_not_protected");
        }
        if (!this.chestLocker.isOwner(block, player) && !player.hasPermission("privatechest.admin")) {
            return new NameResult(false, "container_not_owned");
        }
        NameValidationResult validation = this.validateName(name);
        if (!validation.isValid()) {
            return new NameResult(false, validation.getErrorKey(), validation.getErrorDetails());
        }
        this.containerNames.put(location.clone(), name.trim());
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> this.plugin.getDataManager().saveData());
        this.plugin.getLogger().fine(String.format("[ContainerNames] Player %s named container at %s:%d,%d,%d as '%s'", player.getName(), location.getWorld() != null ? location.getWorld().getName() : "null", location.getBlockX(), location.getBlockY(), location.getBlockZ(), name));
        return new NameResult(true, "container_name_set");
    }

    public NameResult removeContainerName(Location location, Player player) {
        Block block = location.getBlock();
        if (!this.chestLocker.isChestLocked(block)) {
            return new NameResult(false, "container_not_protected");
        }
        if (!this.chestLocker.isOwner(block, player) && !player.hasPermission("privatechest.admin")) {
            return new NameResult(false, "container_not_owned");
        }
        if (!this.hasCustomName(location)) {
            return new NameResult(false, "container_no_custom_name");
        }
        String oldName = this.containerNames.remove(location);
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> this.plugin.getDataManager().saveData());
        this.plugin.getLogger().fine(String.format("[ContainerNames] Player %s removed name '%s' from container at %s:%d,%d,%d", player.getName(), oldName, location.getWorld() != null ? location.getWorld().getName() : "null", location.getBlockX(), location.getBlockY(), location.getBlockZ()));
        return new NameResult(true, "container_name_removed");
    }

    public String getContainerName(Location location) {
        return this.containerNames.get(location);
    }

    public String getDisplayName(Location location) {
        Block block;
        ContainerType type;
        String customName = this.getContainerName(location);
        if (customName != null) {
            return customName;
        }
        if (location.getWorld() != null && (type = ContainerType.fromMaterial((block = location.getBlock()).getType())) != null) {
            return type.getDisplayName();
        }
        return "Container";
    }

    public boolean hasCustomName(Location location) {
        return this.containerNames.containsKey(location);
    }

    private NameValidationResult validateName(String name) {
        if (name == null || name.trim().isEmpty()) {
            return new NameValidationResult(false, "name_empty");
        }
        String trimmedName = name.trim();
        if (trimmedName.length() < 1) {
            return new NameValidationResult(false, "name_too_short", String.valueOf(1));
        }
        if (trimmedName.length() > 16) {
            return new NameValidationResult(false, "name_too_long", String.valueOf(16));
        }
        if (!VALID_NAME_PATTERN.matcher(trimmedName).matches()) {
            return new NameValidationResult(false, "name_invalid_characters");
        }
        for (String forbidden : FORBIDDEN_NAMES) {
            if (!trimmedName.equalsIgnoreCase(forbidden)) continue;
            return new NameValidationResult(false, "name_forbidden");
        }
        return new NameValidationResult(true, null);
    }

    public Map<Location, String> getAllContainerNames() {
        return Collections.unmodifiableMap(this.containerNames);
    }

    public void loadContainerNames(Map<Location, String> names) {
        this.containerNames.clear();
        if (names != null) {
            this.containerNames.putAll(names);
        }
        this.plugin.getLogger().info("[ContainerNames] Loaded " + this.containerNames.size() + " custom container names");
    }

    boolean removeContainerNameEntry(Location location) {
        return this.containerNames.remove(location) != null;
    }

    public int getNamedContainerCount() {
        return this.containerNames.size();
    }

    public static class NameResult {
        private final boolean success;
        private final String messageKey;
        private final String details;

        public NameResult(boolean success, String messageKey) {
            this(success, messageKey, null);
        }

        public NameResult(boolean success, String messageKey, String details) {
            this.success = success;
            this.messageKey = messageKey;
            this.details = details;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public String getMessageKey() {
            return this.messageKey;
        }

        public String getDetails() {
            return this.details;
        }
    }

    private static class NameValidationResult {
        private final boolean valid;
        private final String errorKey;
        private final String errorDetails;

        public NameValidationResult(boolean valid, String errorKey) {
            this(valid, errorKey, null);
        }

        public NameValidationResult(boolean valid, String errorKey, String errorDetails) {
            this.valid = valid;
            this.errorKey = errorKey;
            this.errorDetails = errorDetails;
        }

        public boolean isValid() {
            return this.valid;
        }

        public String getErrorKey() {
            return this.errorKey;
        }

        public String getErrorDetails() {
            return this.errorDetails;
        }
    }
}

