/*
 * Decompiled with CFR 0.152.
 */
package me.tuplugin.privatechest;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import me.tuplugin.privatechest.ChestLocker;
import me.tuplugin.privatechest.ContainerNameManager;
import me.tuplugin.privatechest.PrivateChest;
import me.tuplugin.privatechest.TrustManager;
import me.tuplugin.privatechest.storage.DataStorage;
import me.tuplugin.privatechest.storage.SqliteStorage;
import me.tuplugin.privatechest.storage.YamlStorage;
import org.bukkit.Location;

public class DataManager {
    private final PrivateChest plugin;
    private DataStorage storage;

    public DataManager(PrivateChest plugin) {
        this.plugin = plugin;
        this.initializeStorage();
        this.loadData();
    }

    private void initializeStorage() {
        String storageType;
        switch (storageType = this.plugin.getConfig().getString("storage-type", "yaml").toLowerCase()) {
            case "sqlite": {
                this.plugin.getLogger().info("[PrivateChest] Attempting to initialize SQLite storage...");
                this.storage = new SqliteStorage(this.plugin);
                if (this.storage.initialize()) break;
                this.plugin.getLogger().warning("[PrivateChest] SQLite initialization failed! Falling back to YAML storage.");
                this.storage = new YamlStorage(this.plugin);
                if (this.storage.initialize()) break;
                this.plugin.getLogger().severe("[PrivateChest] YAML storage initialization also failed! Plugin may not work correctly.");
                break;
            }
            default: {
                this.plugin.getLogger().info("[PrivateChest] Using YAML storage.");
                this.storage = new YamlStorage(this.plugin);
                if (this.storage.initialize()) break;
                this.plugin.getLogger().severe("[PrivateChest] YAML storage initialization failed! Plugin may not work correctly.");
            }
        }
        this.plugin.getLogger().info("[PrivateChest] Storage system initialized: " + this.storage.getStorageType());
    }

    public void loadData() {
        Map<String, Set<String>> trustRelations;
        if (this.storage == null || !this.storage.isReady()) {
            this.plugin.getLogger().severe("[PrivateChest] Storage system is not ready! Cannot load data.");
            return;
        }
        ChestLocker chestLocker = ChestLocker.getInstance();
        Map<Location, String> owners = chestLocker.getChestOwners();
        Map<Location, String> passwords = chestLocker.getChestPasswords();
        ContainerNameManager nameManager = this.plugin.getContainerNameManager();
        TrustManager trustManager = this.plugin.getTrustManager();
        ConcurrentHashMap<Location, String> containerNames = nameManager != null ? new ConcurrentHashMap<Location, String>() : null;
        Map<String, Set<String>> map = trustRelations = trustManager != null ? trustManager.getAllTrustRelations() : null;
        if (!this.storage.loadData(owners, passwords, containerNames, trustRelations)) {
            this.plugin.getLogger().severe("[PrivateChest] Failed to load data from storage!");
        } else if (nameManager != null && containerNames != null) {
            nameManager.loadContainerNames(containerNames);
        }
    }

    public void saveData() {
        Map<String, Set<String>> trustRelations;
        if (this.storage == null || !this.storage.isReady()) {
            this.plugin.getLogger().warning("[PrivateChest] Storage system is not ready! Cannot save data.");
            return;
        }
        ChestLocker chestLocker = ChestLocker.getInstance();
        Map<Location, String> owners = chestLocker.getChestOwners();
        Map<Location, String> passwords = chestLocker.getChestPasswords();
        ContainerNameManager nameManager = this.plugin.getContainerNameManager();
        TrustManager trustManager = this.plugin.getTrustManager();
        Map<Location, String> containerNames = nameManager != null ? nameManager.getAllContainerNames() : null;
        Map<String, Set<String>> map = trustRelations = trustManager != null ? trustManager.getAllTrustRelations() : null;
        if (!this.storage.saveData(owners, passwords, containerNames, trustRelations)) {
            this.plugin.getLogger().severe("[PrivateChest] Failed to save data to storage!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean migrateStorage(String fromType, String toType) {
        DataStorage targetStorage;
        DataStorage sourceStorage;
        if (fromType.equals(toType)) {
            this.plugin.getLogger().info("[PrivateChest] Source and target storage types are the same. No migration needed.");
            return true;
        }
        this.plugin.getLogger().info("[PrivateChest] Starting migration from " + fromType + " to " + toType + "...");
        switch (fromType.toLowerCase()) {
            case "yaml": {
                sourceStorage = new YamlStorage(this.plugin);
                break;
            }
            case "sqlite": {
                sourceStorage = new SqliteStorage(this.plugin);
                break;
            }
            default: {
                this.plugin.getLogger().severe("[PrivateChest] Unknown source storage type: " + fromType);
                return false;
            }
        }
        if (!sourceStorage.initialize()) {
            this.plugin.getLogger().severe("[PrivateChest] Failed to initialize source storage for migration!");
            return false;
        }
        switch (toType.toLowerCase()) {
            case "yaml": {
                targetStorage = new YamlStorage(this.plugin);
                break;
            }
            case "sqlite": {
                targetStorage = new SqliteStorage(this.plugin);
                break;
            }
            default: {
                this.plugin.getLogger().severe("[PrivateChest] Unknown target storage type: " + toType);
                sourceStorage.close();
                return false;
            }
        }
        if (!targetStorage.initialize()) {
            this.plugin.getLogger().severe("[PrivateChest] Failed to initialize target storage for migration!");
            sourceStorage.close();
            return false;
        }
        try {
            ChestLocker chestLocker = ChestLocker.getInstance();
            Map<Location, String> owners = chestLocker.getChestOwners();
            Map<Location, String> passwords = chestLocker.getChestPasswords();
            if (!sourceStorage.loadData(owners, passwords)) {
                this.plugin.getLogger().severe("[PrivateChest] Failed to load data from source storage during migration!");
                boolean bl = false;
                return bl;
            }
            int dataCount = owners.size();
            this.plugin.getLogger().info("[PrivateChest] Loaded " + dataCount + " entries from " + fromType + " storage.");
            if (!targetStorage.saveData(owners, passwords)) {
                this.plugin.getLogger().severe("[PrivateChest] Failed to save data to target storage during migration!");
                boolean bl = false;
                return bl;
            }
            this.plugin.getLogger().info("[PrivateChest] Successfully migrated " + dataCount + " entries to " + toType + " storage.");
            if (this.storage != null) {
                this.storage.close();
            }
            this.storage = targetStorage;
            this.plugin.getLogger().info("[PrivateChest] Migration from " + fromType + " to " + toType + " completed successfully!");
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("[PrivateChest] Error during storage migration!");
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            sourceStorage.close();
            if (targetStorage != this.storage) {
                targetStorage.close();
            }
        }
    }

    public String getStorageType() {
        return this.storage != null ? this.storage.getStorageType() : "Unknown";
    }

    public boolean isStorageReady() {
        return this.storage != null && this.storage.isReady();
    }

    public void close() {
        if (this.storage != null) {
            this.storage.close();
            this.storage = null;
        }
    }

    public DataStorage getStorage() {
        return this.storage;
    }
}

