/*
 * Decompiled with CFR 0.152.
 */
package me.tuplugin.privatechest;

import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class FileUtil {
    public static void updateConfig(JavaPlugin plugin, String fileName) {
        try {
            File file = new File(plugin.getDataFolder(), fileName);
            if (!file.exists()) {
                plugin.saveResource(fileName, false);
                return;
            }
            YamlConfiguration existingConfig = YamlConfiguration.loadConfiguration((File)file);
            InputStreamReader defConfigStream = new InputStreamReader(plugin.getResource(fileName));
            YamlConfiguration defaultConfig = YamlConfiguration.loadConfiguration((Reader)defConfigStream);
            boolean changed = false;
            for (String key : defaultConfig.getKeys(true)) {
                if (existingConfig.contains(key)) continue;
                existingConfig.set(key, defaultConfig.get(key));
                changed = true;
            }
            if (changed) {
                existingConfig.save(file);
                plugin.getLogger().info("Updated " + fileName + " with new defaults.");
            }
        }
        catch (Exception e) {
            plugin.getLogger().warning("Could not update " + fileName + ": " + e.getMessage());
        }
    }
}

