/*
 * Decompiled with CFR 0.152.
 */
package me.tuplugin.privatechest;

import java.util.HashSet;
import java.util.Set;
import me.tuplugin.privatechest.ChestLocker;
import me.tuplugin.privatechest.MessageManager;
import me.tuplugin.privatechest.PrivateChest;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Chest;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

public class HopperProtectionListener
implements Listener {
    private final ChestLocker chestLocker;
    private final PrivateChest plugin;
    private final MessageManager messageManager;

    public HopperProtectionListener(PrivateChest plugin) {
        this.plugin = plugin;
        this.chestLocker = ChestLocker.getInstance();
        this.messageManager = plugin.getMessageManager();
    }

    private boolean isHopperAccessAllowed() {
        return this.plugin.getConfig().getBoolean("hopper-protection.allow-hopper-access", false);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onInventoryMove(InventoryMoveItemEvent event) {
        if (this.isHopperAccessAllowed()) {
            return;
        }
        boolean sourceProtected = this.isInventoryProtected(event.getSource());
        boolean destinationProtected = this.isInventoryProtected(event.getDestination());
        if (sourceProtected || destinationProtected) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockPlace(BlockPlaceEvent event) {
        Block placedBlock = event.getBlock();
        Material placedType = placedBlock.getType();
        Player player = event.getPlayer();
        if (!this.isAutomatedExtractionBlock(placedType)) {
            return;
        }
        if (this.isHopperAccessAllowed()) {
            return;
        }
        if (player.hasPermission("privatechest.admin")) {
            return;
        }
        if (this.hasProtectedContainersNearby(placedBlock, this.getExtractionRange(placedType))) {
            event.setCancelled(true);
            player.sendMessage(this.messageManager.get("automated_block_placement_denied").replace("{block}", this.getBlockDisplayName(placedType)));
        }
    }

    private boolean isInventoryProtected(Inventory inventory) {
        if (inventory == null) {
            return false;
        }
        InventoryHolder holder = inventory.getHolder();
        if (holder == null) {
            return false;
        }
        HashSet<Block> containerBlocks = new HashSet<Block>();
        if (holder instanceof BlockState) {
            containerBlocks.addAll(this.getContainerBlocks(((BlockState)holder).getBlock()));
        } else {
            Location loc = inventory.getLocation();
            if (loc != null) {
                containerBlocks.addAll(this.getContainerBlocks(loc.getBlock()));
            }
        }
        if (containerBlocks.isEmpty()) {
            return false;
        }
        for (Block block : containerBlocks) {
            if (!this.chestLocker.isChestLocked(block)) continue;
            return true;
        }
        return false;
    }

    private Set<Block> getContainerBlocks(Block block) {
        Block otherBlock;
        BlockFace facing;
        BlockFace otherHalfDirection;
        Chest chestData;
        Chest.Type chestType;
        HashSet<Block> blocks = new HashSet<Block>();
        if (block == null || !this.isLockableContainer(block.getType())) {
            return blocks;
        }
        blocks.add(block);
        BlockState state = block.getState();
        BlockData blockData = block.getBlockData();
        if (state instanceof org.bukkit.block.Chest && blockData instanceof Chest && (chestType = (chestData = (Chest)blockData).getType()) != Chest.Type.SINGLE && (otherHalfDirection = this.getOtherChestHalfDirection(chestType, facing = chestData.getFacing())) != null && (otherBlock = block.getRelative(otherHalfDirection)).getState() instanceof org.bukkit.block.Chest) {
            blocks.add(otherBlock);
        }
        return blocks;
    }

    private BlockFace getOtherChestHalfDirection(Chest.Type type, BlockFace facing) {
        if (type == Chest.Type.LEFT) {
            switch (facing) {
                case NORTH: {
                    return BlockFace.EAST;
                }
                case EAST: {
                    return BlockFace.SOUTH;
                }
                case SOUTH: {
                    return BlockFace.WEST;
                }
                case WEST: {
                    return BlockFace.NORTH;
                }
            }
            return null;
        }
        if (type == Chest.Type.RIGHT) {
            switch (facing) {
                case NORTH: {
                    return BlockFace.WEST;
                }
                case EAST: {
                    return BlockFace.NORTH;
                }
                case SOUTH: {
                    return BlockFace.EAST;
                }
                case WEST: {
                    return BlockFace.SOUTH;
                }
            }
            return null;
        }
        return null;
    }

    private boolean isLockableContainer(Material type) {
        if (type == Material.CHEST || type == Material.TRAPPED_CHEST || type == Material.BARREL) {
            return true;
        }
        String typeName = type.name();
        return typeName.contains("SHULKER_BOX");
    }

    private boolean isAutomatedExtractionBlock(Material type) {
        return type == Material.HOPPER || type == Material.DROPPER || type == Material.DISPENSER;
    }

    private int getExtractionRange(Material type) {
        switch (type) {
            case HOPPER: {
                return 1;
            }
            case DROPPER: 
            case DISPENSER: {
                return 1;
            }
        }
        return 1;
    }

    private boolean hasProtectedContainersNearby(Block centerBlock, int range) {
        Location centerLoc = centerBlock.getLocation();
        for (int x = -range; x <= range; ++x) {
            for (int y = -range; y <= range; ++y) {
                for (int z = -range; z <= range; ++z) {
                    Location checkLoc = centerLoc.clone().add((double)x, (double)y, (double)z);
                    Block checkBlock = checkLoc.getBlock();
                    if (checkBlock.equals(centerBlock) || !this.isLockableContainer(checkBlock.getType()) || !this.chestLocker.isChestLocked(checkBlock)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private String getBlockDisplayName(Material type) {
        String name = type.name().toLowerCase().replace("_", " ");
        String[] words = name.split(" ");
        StringBuilder result = new StringBuilder();
        for (String word : words) {
            if (word.length() <= 0) continue;
            result.append(Character.toUpperCase(word.charAt(0)));
            if (word.length() > 1) {
                result.append(word.substring(1));
            }
            result.append(" ");
        }
        return result.toString().trim();
    }
}

