/*
 * Decompiled with CFR 0.152.
 */
package me.tuplugin.privatechest;

import java.util.HashMap;
import java.util.Map;
import me.tuplugin.privatechest.ChestLocker;
import me.tuplugin.privatechest.PrivateChest;
import me.tuplugin.privatechest.enums.ContainerType;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class LimitManager {
    private final PrivateChest plugin;
    private final ChestLocker chestLocker;
    private static LimitManager instance;

    public LimitManager(PrivateChest plugin) {
        this.plugin = plugin;
        this.chestLocker = ChestLocker.getInstance();
        instance = this;
    }

    public static LimitManager getInstance() {
        return instance;
    }

    public int getPlayerLimit(Player player) {
        int[] checkLimits;
        if (!this.plugin.getConfig().getBoolean("enable-chest-limits", false)) {
            return -1;
        }
        if (player.hasPermission("privatechest.limit.unlimited")) {
            return -1;
        }
        int maxLimit = this.plugin.getConfig().getInt("default-chest-limit", 5);
        for (int limit : checkLimits = new int[]{1000, 500, 100, 50, 25, 20, 15, 10, 5, 3, 1}) {
            if (!player.hasPermission("privatechest.limit." + limit)) continue;
            maxLimit = Math.max(maxLimit, limit);
            break;
        }
        return maxLimit;
    }

    public int getPlayerLimitForType(Player player, ContainerType containerType) {
        int[] checkLimits;
        if (!this.plugin.getConfig().getBoolean("container-limits.enabled", false)) {
            return this.getPlayerLimit(player);
        }
        if (player.hasPermission("privatechest.limit.unlimited") || player.hasPermission("privatechest.limit." + containerType.getConfigName() + ".unlimited")) {
            return -1;
        }
        int maxLimit = this.plugin.getConfig().getInt("container-limits.types." + containerType.getConfigName(), this.plugin.getConfig().getInt("container-limits.default-limit", 5));
        for (int limit : checkLimits = new int[]{1000, 500, 100, 50, 25, 20, 15, 10, 5, 3, 1}) {
            if (!player.hasPermission("privatechest.limit." + containerType.getConfigName() + "." + limit)) continue;
            maxLimit = Math.max(maxLimit, limit);
            break;
        }
        return maxLimit;
    }

    public int getPlayerContainerCountByType(Player player, ContainerType containerType) {
        String playerUUID = player.getUniqueId().toString();
        Map<Location, String> chestOwners = this.chestLocker.getChestOwners();
        int count = 0;
        for (Map.Entry<Location, String> entry : chestOwners.entrySet()) {
            Block block;
            ContainerType blockType;
            Location loc;
            if (!playerUUID.equals(entry.getValue()) || (loc = entry.getKey()).getWorld() == null || (blockType = ContainerType.fromMaterial((block = loc.getBlock()).getType())) != containerType) continue;
            ++count;
        }
        return count;
    }

    public Map<ContainerType, Integer> getPlayerContainerCountsByType(Player player) {
        HashMap<ContainerType, Integer> counts = new HashMap<ContainerType, Integer>();
        String playerUUID = player.getUniqueId().toString();
        Map<Location, String> chestOwners = this.chestLocker.getChestOwners();
        for (ContainerType type : ContainerType.values()) {
            counts.put(type, 0);
        }
        for (Map.Entry entry : chestOwners.entrySet()) {
            Block block;
            ContainerType blockType;
            Location loc;
            if (!playerUUID.equals(entry.getValue()) || (loc = (Location)entry.getKey()).getWorld() == null || (blockType = ContainerType.fromMaterial((block = loc.getBlock()).getType())) == null) continue;
            counts.put(blockType, (Integer)counts.get((Object)blockType) + 1);
        }
        return counts;
    }

    public boolean canPlayerLockMoreOfType(Player player, ContainerType containerType) {
        int limit = this.getPlayerLimitForType(player, containerType);
        if (limit == -1) {
            return true;
        }
        int currentCount = this.getPlayerContainerCountByType(player, containerType);
        return currentCount < limit;
    }

    public boolean canPlayerLockAdditionalOfType(Player player, ContainerType containerType, int additionalContainers) {
        int limit = this.getPlayerLimitForType(player, containerType);
        if (limit == -1) {
            return true;
        }
        int currentCount = this.getPlayerContainerCountByType(player, containerType);
        return currentCount + additionalContainers <= limit;
    }

    public boolean areGranularLimitsEnabled() {
        return this.plugin.getConfig().getBoolean("container-limits.enabled", false);
    }

    public int getPlayerChestCount(Player player) {
        String playerUUID = player.getUniqueId().toString();
        Map<Location, String> chestOwners = this.chestLocker.getChestOwners();
        int count = 0;
        for (String ownerUUID : chestOwners.values()) {
            if (!playerUUID.equals(ownerUUID)) continue;
            ++count;
        }
        return count;
    }

    public int getPlayerChestCount(String playerUUID) {
        Map<Location, String> chestOwners = this.chestLocker.getChestOwners();
        int count = 0;
        for (String ownerUUID : chestOwners.values()) {
            if (!playerUUID.equals(ownerUUID)) continue;
            ++count;
        }
        return count;
    }

    public boolean canPlayerLockMore(Player player) {
        int limit = this.getPlayerLimit(player);
        if (limit == -1) {
            return true;
        }
        int currentCount = this.getPlayerChestCount(player);
        return currentCount < limit;
    }

    public boolean canPlayerLockAdditional(Player player, int additionalChests) {
        int limit = this.getPlayerLimit(player);
        if (limit == -1) {
            return true;
        }
        int currentCount = this.getPlayerChestCount(player);
        return currentCount + additionalChests <= limit;
    }

    public int getRemainingLocks(Player player) {
        int limit = this.getPlayerLimit(player);
        if (limit == -1) {
            return -1;
        }
        int currentCount = this.getPlayerChestCount(player);
        return Math.max(0, limit - currentCount);
    }

    public String getLimitStatus(Player player) {
        int currentCount = this.getPlayerChestCount(player);
        int limit = this.getPlayerLimit(player);
        if (limit == -1) {
            return currentCount + "/Unlimited";
        }
        return currentCount + "/" + limit;
    }

    public boolean areLimitsEnabled() {
        return this.plugin.getConfig().getBoolean("enable-chest-limits", false);
    }

    public int getDefaultLimit() {
        return this.plugin.getConfig().getInt("default-chest-limit", 5);
    }

    public String getLimitWarningMessage(Player player) {
        if (!this.areLimitsEnabled()) {
            return null;
        }
        int limit = this.getPlayerLimit(player);
        if (limit == -1) {
            return null;
        }
        int currentCount = this.getPlayerChestCount(player);
        int remaining = limit - currentCount;
        if (remaining <= 2 && remaining > 0) {
            return this.plugin.getMessageManager().get("limit_warning").replace("{remaining}", String.valueOf(remaining)).replace("{limit}", String.valueOf(limit));
        }
        if (remaining <= 0) {
            return this.plugin.getMessageManager().get("limit_reached").replace("{limit}", String.valueOf(limit));
        }
        return null;
    }
}

