/*
 * Decompiled with CFR 0.152.
 */
package me.tuplugin.privatechest;

import java.util.HashSet;
import me.tuplugin.privatechest.ChestLocker;
import me.tuplugin.privatechest.LimitManager;
import me.tuplugin.privatechest.MessageManager;
import me.tuplugin.privatechest.PrivateChest;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Chest;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class LockCommand
implements CommandExecutor {
    private final PrivateChest plugin;
    private final ChestLocker chestLocker;
    private final LimitManager limitManager;
    private final MessageManager messages;

    public LockCommand(PrivateChest plugin) {
        this.plugin = plugin;
        this.chestLocker = ChestLocker.getInstance();
        this.limitManager = LimitManager.getInstance();
        this.messages = plugin.getMessageManager();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("This command can only be used by players.");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("privatechest.use")) {
            player.sendMessage(this.messages.raw("no_permission"));
            return true;
        }
        if (args.length != 1) {
            player.sendMessage(this.messages.raw("usage_lock"));
            return true;
        }
        String password = args[0];
        Block targetBlock = player.getTargetBlock(null, 5);
        if (targetBlock == null || !this.isLockableContainer(targetBlock.getType())) {
            player.sendMessage(this.messages.get("not_a_chest"));
            return true;
        }
        HashSet<Block> blocksToLock = new HashSet<Block>();
        BlockState state = targetBlock.getState();
        if (state instanceof org.bukkit.block.Chest) {
            BlockData blockData = targetBlock.getBlockData();
            if (blockData instanceof Chest) {
                Chest chestData = (Chest)blockData;
                Chest.Type chestType = chestData.getType();
                if (chestType == Chest.Type.SINGLE) {
                    blocksToLock.add(targetBlock);
                } else {
                    Block otherBlock;
                    blocksToLock.add(targetBlock);
                    BlockFace facing = chestData.getFacing();
                    BlockFace otherHalfDirection = this.getOtherChestHalfDirection(chestType, facing);
                    if (otherHalfDirection != null && (otherBlock = targetBlock.getRelative(otherHalfDirection)).getState() instanceof org.bukkit.block.Chest) {
                        blocksToLock.add(otherBlock);
                    }
                }
            } else {
                blocksToLock.add(targetBlock);
            }
        } else if (targetBlock.getType() == Material.BARREL) {
            blocksToLock.add(targetBlock);
        } else {
            player.sendMessage(this.messages.get("not_a_chest"));
            return true;
        }
        for (Block block : blocksToLock) {
            if (!this.chestLocker.isChestLocked(block)) continue;
            player.sendMessage(this.messages.get("already_locked"));
            return true;
        }
        if (!player.hasPermission("privatechest.admin") && this.limitManager.areLimitsEnabled() && !this.limitManager.canPlayerLockAdditional(player, blocksToLock.size())) {
            int limit = this.limitManager.getPlayerLimit(player);
            int current = this.limitManager.getPlayerChestCount(player);
            if (limit == -1) {
                player.sendMessage(this.messages.get("limit_error"));
            } else {
                player.sendMessage(this.messages.get("limit_exceeded").replace("{current}", String.valueOf(current)).replace("{limit}", String.valueOf(limit)).replace("{trying}", String.valueOf(blocksToLock.size())));
            }
            return true;
        }
        boolean allLockedSuccessfully = true;
        for (Block block : blocksToLock) {
            if (this.chestLocker.lockChest(block, player, password)) continue;
            allLockedSuccessfully = false;
            break;
        }
        if (allLockedSuccessfully) {
            this.plugin.getDataManager().saveData();
            player.sendMessage(this.messages.get("locked"));
            String warningMessage = this.limitManager.getLimitWarningMessage(player);
            if (warningMessage != null) {
                player.sendMessage(warningMessage);
            }
            if (this.limitManager.areLimitsEnabled() && !player.hasPermission("privatechest.admin")) {
                String status = this.limitManager.getLimitStatus(player);
                player.sendMessage(this.messages.get("limit_status").replace("{status}", status));
            }
        } else {
            player.sendMessage(this.messages.get("error_generic"));
        }
        return true;
    }

    private BlockFace getOtherChestHalfDirection(Chest.Type type, BlockFace facing) {
        if (type == Chest.Type.LEFT) {
            switch (facing) {
                case NORTH: {
                    return BlockFace.EAST;
                }
                case EAST: {
                    return BlockFace.SOUTH;
                }
                case SOUTH: {
                    return BlockFace.WEST;
                }
                case WEST: {
                    return BlockFace.NORTH;
                }
            }
            return null;
        }
        if (type == Chest.Type.RIGHT) {
            switch (facing) {
                case NORTH: {
                    return BlockFace.WEST;
                }
                case EAST: {
                    return BlockFace.NORTH;
                }
                case SOUTH: {
                    return BlockFace.EAST;
                }
                case WEST: {
                    return BlockFace.SOUTH;
                }
            }
            return null;
        }
        return null;
    }

    private boolean isLockableContainer(Material type) {
        return type == Material.CHEST || type == Material.TRAPPED_CHEST || type == Material.BARREL;
    }
}

