/*
 * Decompiled with CFR 0.152.
 */
package me.tuplugin.privatechest;

import java.io.File;
import me.tuplugin.privatechest.FileUtil;
import me.tuplugin.privatechest.PrivateChest;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class MessageManager {
    private final PrivateChest plugin;
    private FileConfiguration messages;
    private String prefix;
    private boolean usePrefix;

    public MessageManager(PrivateChest plugin) {
        this.plugin = plugin;
        this.loadMessages();
    }

    private void loadMessages() {
        File file = new File(this.plugin.getDataFolder(), "messages.yml");
        FileUtil.updateConfig(this.plugin, "messages.yml");
        this.messages = YamlConfiguration.loadConfiguration((File)file);
        this.loadPrefixSettings();
    }

    private void loadPrefixSettings() {
        FileConfiguration config = this.plugin.getConfig();
        this.usePrefix = config.getBoolean("use-prefix", true);
        this.prefix = this.translate(config.getString("prefix", "&7[&6PrivateChest&7] "));
    }

    public void reload() {
        File file = new File(this.plugin.getDataFolder(), "messages.yml");
        FileUtil.updateConfig(this.plugin, "messages.yml");
        this.messages = YamlConfiguration.loadConfiguration((File)file);
        this.loadPrefixSettings();
    }

    public String get(String key) {
        String msg = this.messages.getString(key, "Message not found: " + key);
        if (this.usePrefix) {
            return this.prefix + this.translate(msg);
        }
        return this.translate(msg);
    }

    public String raw(String key) {
        return this.translate(this.messages.getString(key, "Message not found: " + key));
    }

    private String translate(String text) {
        return text == null ? "" : ChatColor.translateAlternateColorCodes((char)'&', (String)text);
    }

    public String getForPlayer(String key, Player player) {
        String message = this.get(key);
        if (player != null && this.plugin.getBedrockUtils() != null) {
            boolean isBedrockPlayer = this.plugin.getBedrockUtils().isBedrockPlayer(player);
            message = this.plugin.getBedrockUtils().adaptMessageForBedrock(message, isBedrockPlayer);
        }
        return message;
    }

    public String rawForPlayer(String key, Player player) {
        String message = this.raw(key);
        if (player != null && this.plugin.getBedrockUtils() != null) {
            boolean isBedrockPlayer = this.plugin.getBedrockUtils().isBedrockPlayer(player);
            message = this.plugin.getBedrockUtils().adaptMessageForBedrock(message, isBedrockPlayer);
        }
        return message;
    }

    public void sendMessage(Player player, String key) {
        if (player != null) {
            player.sendMessage(this.getForPlayer(key, player));
        }
    }

    public void sendRawMessage(Player player, String key) {
        if (player != null) {
            player.sendMessage(this.rawForPlayer(key, player));
        }
    }

    public boolean isBedrockCompatible(String message) {
        if (this.plugin.getBedrockUtils() == null) {
            return true;
        }
        String plainMessage = ChatColor.stripColor((String)this.translate(message));
        return this.plugin.getBedrockUtils().isBedrockSafeName(plainMessage);
    }
}

