/*
 * Decompiled with CFR 0.152.
 */
package me.tuplugin.privatechest;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public class PasswordManager {
    private static final String ALGORITHM = "SHA-256";
    private static final int SALT_LENGTH = 16;
    private static final String SEPARATOR = ":";

    public static String hashPassword(String password) {
        try {
            byte[] salt = PasswordManager.generateSalt();
            String hash = PasswordManager.hashWithSalt(password, salt);
            if (hash == null) {
                return null;
            }
            return PasswordManager.bytesToHex(salt) + SEPARATOR + hash;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean verifyPassword(String password, String storedHash) {
        if (password == null || storedHash == null) {
            return false;
        }
        try {
            String[] parts = storedHash.split(SEPARATOR, 2);
            if (parts.length != 2) {
                return false;
            }
            byte[] salt = PasswordManager.hexToBytes(parts[0]);
            String expectedHash = parts[1];
            String actualHash = PasswordManager.hashWithSalt(password, salt);
            return expectedHash != null && expectedHash.equals(actualHash);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isPlainText(String storedPassword) {
        return storedPassword != null && !storedPassword.contains(SEPARATOR);
    }

    public static String migratePlainPassword(String plainPassword) {
        return PasswordManager.hashPassword(plainPassword);
    }

    private static byte[] generateSalt() {
        SecureRandom random = new SecureRandom();
        byte[] salt = new byte[16];
        random.nextBytes(salt);
        return salt;
    }

    private static String hashWithSalt(String password, byte[] salt) {
        try {
            MessageDigest digest = MessageDigest.getInstance(ALGORITHM);
            digest.update(salt);
            byte[] hashedBytes = digest.digest(password.getBytes(StandardCharsets.UTF_8));
            return PasswordManager.bytesToHex(hashedBytes);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuilder result = new StringBuilder();
        for (byte b : bytes) {
            result.append(String.format("%02x", b));
        }
        return result.toString();
    }

    private static byte[] hexToBytes(String hex) {
        int length = hex.length();
        byte[] data = new byte[length / 2];
        for (int i = 0; i < length; i += 2) {
            data[i / 2] = (byte)((Character.digit(hex.charAt(i), 16) << 4) + Character.digit(hex.charAt(i + 1), 16));
        }
        return data;
    }
}

