/*
 * Decompiled with CFR 0.152.
 */
package me.tuplugin.privatechest;

import me.tuplugin.privatechest.AutoCleanupManager;
import me.tuplugin.privatechest.BedrockUtils;
import me.tuplugin.privatechest.BlockProtectionListener;
import me.tuplugin.privatechest.ChestListener;
import me.tuplugin.privatechest.ChestLocker;
import me.tuplugin.privatechest.ClearChestsCommand;
import me.tuplugin.privatechest.ContainerNameManager;
import me.tuplugin.privatechest.DataManager;
import me.tuplugin.privatechest.FileUtil;
import me.tuplugin.privatechest.HopperProtectionListener;
import me.tuplugin.privatechest.LimitManager;
import me.tuplugin.privatechest.LockCommand;
import me.tuplugin.privatechest.MessageManager;
import me.tuplugin.privatechest.ReloadCommand;
import me.tuplugin.privatechest.RenameCommand;
import me.tuplugin.privatechest.SignProtectionListener;
import me.tuplugin.privatechest.TrustManager;
import me.tuplugin.privatechest.UnlockCommand;
import me.tuplugin.privatechest.commands.TrustCommand;
import me.tuplugin.privatechest.commands.UntrustCommand;
import me.tuplugin.privatechest.metrics.bukkit.Metrics;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class PrivateChest
extends JavaPlugin {
    private static PrivateChest instance;
    private MessageManager messageManager;
    private DataManager dataManager;
    private ChestLocker chestLocker;
    private TrustManager trustManager;
    private LimitManager limitManager;
    private AutoCleanupManager autoCleanupManager;
    private ContainerNameManager containerNameManager;
    private BedrockUtils bedrockUtils;

    public void onEnable() {
        instance = this;
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        FileUtil.updateConfig(this, "config.yml");
        FileUtil.updateConfig(this, "messages.yml");
        this.saveDefaultConfig();
        new Metrics(this, 25606);
        this.messageManager = new MessageManager(this);
        this.chestLocker = new ChestLocker(this);
        this.trustManager = new TrustManager(this);
        this.limitManager = new LimitManager(this);
        this.containerNameManager = new ContainerNameManager(this);
        this.bedrockUtils = new BedrockUtils(this);
        this.dataManager = new DataManager(this);
        this.autoCleanupManager = new AutoCleanupManager(this);
        this.autoCleanupManager.initialize();
        this.getLogger().info("Checking for plain text passwords to migrate...");
        this.chestLocker.migrateAllPasswords();
        this.getCommand("privatechest").setExecutor((CommandExecutor)new ReloadCommand(this));
        this.getCommand("lockchest").setExecutor((CommandExecutor)new LockCommand(this));
        this.getCommand("unlockchest").setExecutor((CommandExecutor)new UnlockCommand(this));
        this.getCommand("clearchests").setExecutor((CommandExecutor)new ClearChestsCommand(this));
        this.getCommand("trust").setExecutor((CommandExecutor)new TrustCommand(this));
        this.getCommand("untrust").setExecutor((CommandExecutor)new UntrustCommand(this));
        this.getCommand("renamecontainer").setExecutor((CommandExecutor)new RenameCommand(this));
        this.getServer().getPluginManager().registerEvents((Listener)new ChestListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new BlockProtectionListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new HopperProtectionListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new SignProtectionListener(this), (Plugin)this);
        this.getLogger().info("\u2705 PrivateChest has been enabled successfully.");
    }

    public void onDisable() {
        if (this.autoCleanupManager != null) {
            this.autoCleanupManager.shutdown();
        }
        if (this.dataManager != null) {
            this.dataManager.close();
        }
        this.getLogger().info("\u26d4 PrivateChest has been disabled.");
    }

    public static PrivateChest getInstance() {
        return instance;
    }

    public MessageManager getMessageManager() {
        return this.messageManager;
    }

    public DataManager getDataManager() {
        return this.dataManager;
    }

    public ChestLocker getChestLocker() {
        return this.chestLocker;
    }

    public TrustManager getTrustManager() {
        return this.trustManager;
    }

    public LimitManager getLimitManager() {
        return this.limitManager;
    }

    public AutoCleanupManager getAutoCleanupManager() {
        return this.autoCleanupManager;
    }

    public ContainerNameManager getContainerNameManager() {
        return this.containerNameManager;
    }

    public BedrockUtils getBedrockUtils() {
        return this.bedrockUtils;
    }
}

