/*
 * Decompiled with CFR 0.152.
 */
package me.tuplugin.privatechest;

import me.tuplugin.privatechest.ChestLocker;
import me.tuplugin.privatechest.ContainerNameManager;
import me.tuplugin.privatechest.MessageManager;
import me.tuplugin.privatechest.PrivateChest;
import me.tuplugin.privatechest.enums.ContainerType;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.util.RayTraceResult;

public class RenameCommand
implements CommandExecutor {
    private final PrivateChest plugin;
    private final ContainerNameManager nameManager;
    private final ChestLocker chestLocker;
    private final MessageManager messageManager;

    public RenameCommand(PrivateChest plugin) {
        this.plugin = plugin;
        this.nameManager = plugin.getContainerNameManager();
        this.chestLocker = plugin.getChestLocker();
        this.messageManager = plugin.getMessageManager();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCommand;
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.messageManager.raw("console_only_player"));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("privatechest.use")) {
            player.sendMessage(this.messageManager.raw("no_permission"));
            return true;
        }
        if (args.length == 0) {
            player.sendMessage(this.messageManager.get("usage_rename_container"));
            return true;
        }
        Block targetBlock = this.getTargetBlock(player);
        if (targetBlock == null || !ContainerType.isLockableContainer(targetBlock.getType())) {
            player.sendMessage(this.messageManager.raw("not_a_chest"));
            return true;
        }
        Location targetLocation = targetBlock.getLocation();
        switch (subCommand = args[0].toLowerCase()) {
            case "remove": 
            case "clear": 
            case "delete": {
                this.handleRemoveName(player, targetLocation);
                break;
            }
            default: {
                String newName = String.join((CharSequence)" ", args);
                this.handleSetName(player, targetLocation, newName);
            }
        }
        return true;
    }

    private void handleSetName(Player player, Location location, String name) {
        ContainerNameManager.NameResult result = this.nameManager.setContainerName(location, player, name);
        if (result.isSuccess()) {
            player.sendMessage(this.messageManager.get(result.getMessageKey()).replace("{name}", name).replace("{container}", this.getContainerTypeName(location)));
        } else {
            String message = this.messageManager.get(result.getMessageKey());
            if (result.getDetails() != null) {
                message = message.replace("{details}", result.getDetails()).replace("{limit}", result.getDetails());
            }
            player.sendMessage(message);
        }
    }

    private void handleRemoveName(Player player, Location location) {
        ContainerNameManager.NameResult result = this.nameManager.removeContainerName(location, player);
        if (result.isSuccess()) {
            player.sendMessage(this.messageManager.get(result.getMessageKey()).replace("{container}", this.getContainerTypeName(location)));
        } else {
            player.sendMessage(this.messageManager.get(result.getMessageKey()));
        }
    }

    private Block getTargetBlock(Player player) {
        RayTraceResult result = player.rayTraceBlocks(5.0);
        if (result != null && result.getHitBlock() != null) {
            return result.getHitBlock();
        }
        return null;
    }

    private String getContainerTypeName(Location location) {
        if (location.getWorld() == null) {
            return "Container";
        }
        Block block = location.getBlock();
        ContainerType type = ContainerType.fromMaterial(block.getType());
        if (type != null) {
            return type.getDisplayName();
        }
        return "Container";
    }
}

