/*
 * Decompiled with CFR 0.152.
 */
package me.tuplugin.privatechest;

import java.util.HashSet;
import java.util.Set;
import me.tuplugin.privatechest.ChestLocker;
import me.tuplugin.privatechest.LimitManager;
import me.tuplugin.privatechest.MessageManager;
import me.tuplugin.privatechest.PrivateChest;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Chest;
import org.bukkit.block.data.type.WallSign;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.SignChangeEvent;

public class SignProtectionListener
implements Listener {
    private final PrivateChest plugin;
    private final ChestLocker chestLocker;
    private final LimitManager limitManager;
    private final MessageManager messages;
    private static final String PRIVATE_SIGN_TEXT = "[Private]";
    private static final String PRIVATE_SIGN_FORMATTED = "\u00a74[\u00a7cPrivate\u00a74]";

    public SignProtectionListener(PrivateChest plugin) {
        this.plugin = plugin;
        this.chestLocker = ChestLocker.getInstance();
        this.limitManager = LimitManager.getInstance();
        this.messages = plugin.getMessageManager();
    }

    @EventHandler
    public void onSignChange(SignChangeEvent event) {
        boolean bl;
        if (!this.plugin.getConfig().getBoolean("enable-sign-protection", true)) {
            return;
        }
        Player player = event.getPlayer();
        String[] lines = event.getLines();
        if (lines[0] == null || !lines[0].equalsIgnoreCase(PRIVATE_SIGN_TEXT)) {
            return;
        }
        if (!player.hasPermission("privatechest.use")) {
            player.sendMessage(this.messages.raw("no_permission"));
            event.setCancelled(true);
            return;
        }
        Block signBlock = event.getBlock();
        Set<Block> chestBlocks = this.findNearbyChests(signBlock);
        if (chestBlocks.isEmpty()) {
            player.sendMessage(this.messages.get("sign_no_chest_found"));
            event.setCancelled(true);
            return;
        }
        for (Block block : chestBlocks) {
            if (!this.chestLocker.isChestLocked(block)) continue;
            player.sendMessage(this.messages.get("sign_chest_already_locked"));
            event.setCancelled(true);
            return;
        }
        for (Block block : chestBlocks) {
            if (!this.chestLocker.isChestLocked(block) || this.chestLocker.isOwner(block, player) || player.hasPermission("privatechest.admin")) continue;
            player.sendMessage(this.messages.get("sign_not_your_chest"));
            event.setCancelled(true);
            return;
        }
        if (!player.hasPermission("privatechest.admin") && this.limitManager.areLimitsEnabled()) {
            int newChestsToLock = 0;
            for (Block chestBlock : chestBlocks) {
                if (this.chestLocker.isChestLocked(chestBlock)) continue;
                ++newChestsToLock;
            }
            if (newChestsToLock > 0 && !this.limitManager.canPlayerLockAdditional(player, newChestsToLock)) {
                int n = this.limitManager.getPlayerLimit(player);
                int current = this.limitManager.getPlayerChestCount(player);
                player.sendMessage(this.messages.get("sign_limit_exceeded").replace("{current}", String.valueOf(current)).replace("{limit}", String.valueOf(n)).replace("{trying}", String.valueOf(newChestsToLock)));
                event.setCancelled(true);
                return;
            }
        }
        String defaultPassword = this.generateSignPassword(player, signBlock);
        boolean bl2 = false;
        for (Block chestBlock : chestBlocks) {
            if (!this.chestLocker.lockChest(chestBlock, player, defaultPassword)) continue;
            bl = true;
        }
        if (bl) {
            this.plugin.getDataManager().saveData();
            event.setLine(0, PRIVATE_SIGN_FORMATTED);
            event.setLine(1, player.getName());
            event.setLine(2, "");
            event.setLine(3, "");
            player.sendMessage(this.messages.get("sign_chest_locked"));
            String warningMessage = this.limitManager.getLimitWarningMessage(player);
            if (warningMessage != null) {
                player.sendMessage(warningMessage);
            }
            if (this.limitManager.areLimitsEnabled() && !player.hasPermission("privatechest.admin")) {
                String status = this.limitManager.getLimitStatus(player);
                player.sendMessage(this.messages.get("limit_status").replace("{status}", status));
            }
        } else {
            player.sendMessage(this.messages.get("sign_lock_failed"));
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onSignBreak(BlockBreakEvent event) {
        if (!this.plugin.getConfig().getBoolean("enable-sign-protection", true)) {
            return;
        }
        Block block = event.getBlock();
        Player player = event.getPlayer();
        if (!this.isSign(block.getType())) {
            return;
        }
        BlockState state = block.getState();
        if (!(state instanceof Sign)) {
            return;
        }
        Sign sign = (Sign)state;
        String[] lines = sign.getLines();
        if (lines[0] == null || !lines[0].contains("Private")) {
            return;
        }
        Set<Block> chestBlocks = this.findNearbyChests(block);
        if (chestBlocks.isEmpty()) {
            return;
        }
        Block lockedChest = null;
        for (Block chestBlock : chestBlocks) {
            if (!this.chestLocker.isChestLocked(chestBlock)) continue;
            lockedChest = chestBlock;
            break;
        }
        if (lockedChest == null) {
            return;
        }
        if (!this.chestLocker.isOwner(lockedChest, player) && !player.hasPermission("privatechest.admin")) {
            event.setCancelled(true);
            player.sendMessage(this.messages.get("sign_cannot_break"));
            return;
        }
        for (Block chestBlock : chestBlocks) {
            if (!this.chestLocker.isChestLocked(chestBlock)) continue;
            this.chestLocker.removeProtection(chestBlock);
        }
        this.plugin.getDataManager().saveData();
        if (this.chestLocker.isOwner(lockedChest, player)) {
            player.sendMessage(this.messages.get("sign_chest_unlocked"));
        } else {
            player.sendMessage(this.messages.get("admin_sign_break_notice"));
        }
    }

    private Set<Block> findNearbyChests(Block signBlock) {
        BlockFace[] horizontalFaces;
        Block blockBelow;
        WallSign wallSign;
        BlockFace facing;
        Block attachedBlock;
        HashSet<Block> chestBlocks = new HashSet<Block>();
        if (signBlock.getBlockData() instanceof WallSign && this.isLockableContainer((attachedBlock = signBlock.getRelative(facing = (wallSign = (WallSign)signBlock.getBlockData()).getFacing().getOppositeFace())).getType())) {
            chestBlocks.addAll(this.getContainerBlocks(attachedBlock));
        }
        if (this.isLockableContainer((blockBelow = signBlock.getRelative(BlockFace.DOWN)).getType())) {
            chestBlocks.addAll(this.getContainerBlocks(blockBelow));
        }
        for (BlockFace face : horizontalFaces = new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST}) {
            Block adjacent = signBlock.getRelative(face);
            if (!this.isLockableContainer(adjacent.getType())) continue;
            chestBlocks.addAll(this.getContainerBlocks(adjacent));
        }
        return chestBlocks;
    }

    private Set<Block> getContainerBlocks(Block block) {
        Block otherBlock;
        BlockFace facing;
        BlockFace otherHalfDirection;
        Chest chestData;
        Chest.Type chestType;
        HashSet<Block> blocks = new HashSet<Block>();
        blocks.add(block);
        BlockState state = block.getState();
        BlockData blockData = block.getBlockData();
        if (state instanceof org.bukkit.block.Chest && blockData instanceof Chest && (chestType = (chestData = (Chest)blockData).getType()) != Chest.Type.SINGLE && (otherHalfDirection = this.getOtherChestHalfDirection(chestType, facing = chestData.getFacing())) != null && (otherBlock = block.getRelative(otherHalfDirection)).getState() instanceof org.bukkit.block.Chest) {
            blocks.add(otherBlock);
        }
        return blocks;
    }

    private BlockFace getOtherChestHalfDirection(Chest.Type type, BlockFace facing) {
        if (type == Chest.Type.LEFT) {
            switch (facing) {
                case NORTH: {
                    return BlockFace.EAST;
                }
                case EAST: {
                    return BlockFace.SOUTH;
                }
                case SOUTH: {
                    return BlockFace.WEST;
                }
                case WEST: {
                    return BlockFace.NORTH;
                }
            }
            return null;
        }
        if (type == Chest.Type.RIGHT) {
            switch (facing) {
                case NORTH: {
                    return BlockFace.WEST;
                }
                case EAST: {
                    return BlockFace.NORTH;
                }
                case SOUTH: {
                    return BlockFace.EAST;
                }
                case WEST: {
                    return BlockFace.SOUTH;
                }
            }
            return null;
        }
        return null;
    }

    private String generateSignPassword(Player player, Block signBlock) {
        String base = player.getUniqueId().toString() + "_" + signBlock.getX() + "_" + signBlock.getY() + "_" + signBlock.getZ();
        return "sign_" + Integer.toHexString(base.hashCode());
    }

    private boolean isSign(Material material) {
        return material.name().contains("SIGN");
    }

    private boolean isLockableContainer(Material type) {
        return type == Material.CHEST || type == Material.TRAPPED_CHEST || type == Material.BARREL;
    }
}

