/*
 * Decompiled with CFR 0.152.
 */
package me.tuplugin.privatechest;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.tuplugin.privatechest.PrivateChest;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class TrustManager {
    private final Map<String, Set<String>> trustRelations = new HashMap<String, Set<String>>();
    private static TrustManager instance;
    private final PrivateChest plugin;

    public TrustManager(PrivateChest plugin) {
        this.plugin = plugin;
        instance = this;
    }

    public static TrustManager getInstance() {
        return instance;
    }

    public boolean trustPlayer(Player owner, Player trusted) {
        if (owner == null || trusted == null) {
            return false;
        }
        if (owner.getUniqueId().equals(trusted.getUniqueId())) {
            return false;
        }
        String ownerUUID = owner.getUniqueId().toString();
        String trustedUUID = trusted.getUniqueId().toString();
        this.trustRelations.computeIfAbsent(ownerUUID, k -> new HashSet());
        return this.trustRelations.get(ownerUUID).add(trustedUUID);
    }

    public boolean trustPlayer(String ownerUUID, String trustedUUID) {
        if (ownerUUID == null || trustedUUID == null) {
            return false;
        }
        if (ownerUUID.equals(trustedUUID)) {
            return false;
        }
        this.trustRelations.computeIfAbsent(ownerUUID, k -> new HashSet());
        return this.trustRelations.get(ownerUUID).add(trustedUUID);
    }

    public boolean untrustPlayer(Player owner, Player trusted) {
        if (owner == null || trusted == null) {
            return false;
        }
        String ownerUUID = owner.getUniqueId().toString();
        String trustedUUID = trusted.getUniqueId().toString();
        Set<String> trusted_players = this.trustRelations.get(ownerUUID);
        if (trusted_players == null) {
            return false;
        }
        boolean removed = trusted_players.remove(trustedUUID);
        if (trusted_players.isEmpty()) {
            this.trustRelations.remove(ownerUUID);
        }
        return removed;
    }

    public boolean untrustPlayer(String ownerUUID, String trustedUUID) {
        if (ownerUUID == null || trustedUUID == null) {
            return false;
        }
        Set<String> trusted_players = this.trustRelations.get(ownerUUID);
        if (trusted_players == null) {
            return false;
        }
        boolean removed = trusted_players.remove(trustedUUID);
        if (trusted_players.isEmpty()) {
            this.trustRelations.remove(ownerUUID);
        }
        return removed;
    }

    public boolean isTrusted(Player owner, Player accessor) {
        if (owner == null || accessor == null) {
            return false;
        }
        if (owner.getUniqueId().equals(accessor.getUniqueId())) {
            return true;
        }
        String ownerUUID = owner.getUniqueId().toString();
        String accessorUUID = accessor.getUniqueId().toString();
        return this.isTrusted(ownerUUID, accessorUUID);
    }

    public boolean isTrusted(String ownerUUID, String accessorUUID) {
        if (ownerUUID == null || accessorUUID == null) {
            return false;
        }
        if (ownerUUID.equals(accessorUUID)) {
            return true;
        }
        Set<String> trusted_players = this.trustRelations.get(ownerUUID);
        return trusted_players != null && trusted_players.contains(accessorUUID);
    }

    public Set<String> getTrustedPlayers(Player owner) {
        if (owner == null) {
            return new HashSet<String>();
        }
        return this.getTrustedPlayers(owner.getUniqueId().toString());
    }

    public Set<String> getTrustedPlayers(String ownerUUID) {
        if (ownerUUID == null) {
            return new HashSet<String>();
        }
        Set<String> trusted = this.trustRelations.get(ownerUUID);
        return trusted != null ? new HashSet<String>(trusted) : new HashSet();
    }

    public Set<String> getOwnersTrusting(Player trustedPlayer) {
        if (trustedPlayer == null) {
            return new HashSet<String>();
        }
        return this.getOwnersTrusting(trustedPlayer.getUniqueId().toString());
    }

    public Set<String> getOwnersTrusting(String trustedUUID) {
        if (trustedUUID == null) {
            return new HashSet<String>();
        }
        HashSet<String> owners = new HashSet<String>();
        for (Map.Entry<String, Set<String>> entry : this.trustRelations.entrySet()) {
            if (!entry.getValue().contains(trustedUUID)) continue;
            owners.add(entry.getKey());
        }
        return owners;
    }

    public void removePlayerCompletely(String playerUUID) {
        if (playerUUID == null) {
            return;
        }
        this.trustRelations.remove(playerUUID);
        for (Set<String> trustedSet : this.trustRelations.values()) {
            trustedSet.remove(playerUUID);
        }
        this.trustRelations.entrySet().removeIf(entry -> ((Set)entry.getValue()).isEmpty());
    }

    public Map<String, Set<String>> getAllTrustRelations() {
        return this.trustRelations;
    }

    public void clearAllTrust() {
        this.trustRelations.clear();
    }

    public int getTotalTrustCount() {
        return this.trustRelations.values().stream().mapToInt(Set::size).sum();
    }

    public String getPlayerName(String uuid) {
        if (uuid == null) {
            return "Unknown";
        }
        try {
            Player player = Bukkit.getPlayer((UUID)UUID.fromString(uuid));
            if (player != null) {
                return player.getName();
            }
            return Bukkit.getOfflinePlayer((UUID)UUID.fromString(uuid)).getName();
        }
        catch (IllegalArgumentException e) {
            return "Unknown";
        }
    }
}

