/*
 * Decompiled with CFR 0.152.
 */
package me.tuplugin.privatechest;

import java.util.HashSet;
import java.util.Set;
import me.tuplugin.privatechest.ChestLocker;
import me.tuplugin.privatechest.MessageManager;
import me.tuplugin.privatechest.PrivateChest;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Chest;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class UnlockCommand
implements CommandExecutor {
    private final PrivateChest plugin;
    private final ChestLocker chestLocker;
    private final MessageManager messages;

    public UnlockCommand(PrivateChest plugin) {
        this.plugin = plugin;
        this.chestLocker = ChestLocker.getInstance();
        this.messages = plugin.getMessageManager();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("This command can only be used by players.");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("privatechest.use")) {
            player.sendMessage(this.messages.raw("no_permission"));
            return true;
        }
        if (args.length != 1) {
            player.sendMessage(this.messages.raw("usage_unlock"));
            return true;
        }
        String password = args[0];
        Block targetBlock = player.getTargetBlock(null, 5);
        if (targetBlock == null || !this.isLockableContainer(targetBlock.getType())) {
            player.sendMessage(this.messages.get("not_a_chest"));
            return true;
        }
        Set<Block> containerBlocks = this.getContainerBlocks(targetBlock);
        Block lockedBlock = null;
        for (Block part : containerBlocks) {
            if (!this.chestLocker.isChestLocked(part)) continue;
            lockedBlock = part;
            break;
        }
        if (lockedBlock == null) {
            player.sendMessage(this.messages.raw("not_locked"));
            return true;
        }
        if (!this.chestLocker.isOwner(lockedBlock, player)) {
            player.sendMessage(this.messages.get("not_your_chest"));
            return true;
        }
        boolean success = this.chestLocker.unlockChest(lockedBlock, player, password);
        if (success) {
            for (Block part : containerBlocks) {
                if (!this.chestLocker.isChestLocked(part)) continue;
                this.chestLocker.removeProtection(part);
            }
            this.plugin.getDataManager().saveData();
            player.sendMessage(this.messages.get("unlocked"));
        } else {
            player.sendMessage(this.messages.get("wrong_password"));
        }
        return true;
    }

    private Set<Block> getContainerBlocks(Block block) {
        Block otherBlock;
        BlockFace facing;
        BlockFace otherHalfDirection;
        Chest chestData;
        Chest.Type chestType;
        HashSet<Block> blocks = new HashSet<Block>();
        blocks.add(block);
        BlockState state = block.getState();
        BlockData blockData = block.getBlockData();
        if (state instanceof org.bukkit.block.Chest && blockData instanceof Chest && (chestType = (chestData = (Chest)blockData).getType()) != Chest.Type.SINGLE && (otherHalfDirection = this.getOtherChestHalfDirection(chestType, facing = chestData.getFacing())) != null && (otherBlock = block.getRelative(otherHalfDirection)).getState() instanceof org.bukkit.block.Chest) {
            blocks.add(otherBlock);
        }
        return blocks;
    }

    private BlockFace getOtherChestHalfDirection(Chest.Type type, BlockFace facing) {
        if (type == Chest.Type.LEFT) {
            switch (facing) {
                case NORTH: {
                    return BlockFace.EAST;
                }
                case EAST: {
                    return BlockFace.SOUTH;
                }
                case SOUTH: {
                    return BlockFace.WEST;
                }
                case WEST: {
                    return BlockFace.NORTH;
                }
            }
            return null;
        }
        if (type == Chest.Type.RIGHT) {
            switch (facing) {
                case NORTH: {
                    return BlockFace.WEST;
                }
                case EAST: {
                    return BlockFace.NORTH;
                }
                case SOUTH: {
                    return BlockFace.EAST;
                }
                case WEST: {
                    return BlockFace.SOUTH;
                }
            }
            return null;
        }
        return null;
    }

    private boolean isLockableContainer(Material type) {
        return type == Material.CHEST || type == Material.TRAPPED_CHEST || type == Material.BARREL;
    }
}

