/*
 * Decompiled with CFR 0.152.
 */
package me.tuplugin.privatechest.api;

import java.util.UUID;
import me.tuplugin.privatechest.ChestLocker;
import me.tuplugin.privatechest.PrivateChest;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class PrivateChestAPI {
    public static boolean isLocked(Block block) {
        if (block == null) {
            throw new IllegalArgumentException("Block cannot be null");
        }
        ChestLocker locker = PrivateChestAPI.getChestLocker();
        if (locker == null) {
            return false;
        }
        return locker.isChestLocked(block);
    }

    public static boolean isOwner(Block block, Player player) {
        if (block == null) {
            throw new IllegalArgumentException("Block cannot be null");
        }
        if (player == null) {
            throw new IllegalArgumentException("Player cannot be null");
        }
        ChestLocker locker = PrivateChestAPI.getChestLocker();
        if (locker == null) {
            return false;
        }
        return locker.isOwner(block, player);
    }

    public static boolean isOwner(Block block, UUID playerUUID) {
        if (block == null) {
            throw new IllegalArgumentException("Block cannot be null");
        }
        if (playerUUID == null) {
            throw new IllegalArgumentException("Player UUID cannot be null");
        }
        ChestLocker locker = PrivateChestAPI.getChestLocker();
        if (locker == null) {
            return false;
        }
        String ownerUUID = locker.getOwnerUUID(block);
        return ownerUUID != null && ownerUUID.equals(playerUUID.toString());
    }

    public static boolean lockBlock(Block block, Player player, String password) {
        PrivateChest plugin;
        if (block == null) {
            throw new IllegalArgumentException("Block cannot be null");
        }
        if (player == null) {
            throw new IllegalArgumentException("Player cannot be null");
        }
        if (password == null || password.trim().isEmpty()) {
            throw new IllegalArgumentException("Password cannot be null or empty");
        }
        if (!PrivateChestAPI.isLockableContainer(block.getType())) {
            throw new UnsupportedOperationException("Block type " + block.getType() + " is not lockable");
        }
        ChestLocker locker = PrivateChestAPI.getChestLocker();
        if (locker == null) {
            return false;
        }
        boolean success = locker.lockChest(block, player, password);
        if (success && (plugin = PrivateChest.getInstance()) != null && plugin.getDataManager() != null) {
            plugin.getDataManager().saveData();
        }
        return success;
    }

    public static boolean unlockBlock(Block block) {
        if (block == null) {
            throw new IllegalArgumentException("Block cannot be null");
        }
        ChestLocker locker = PrivateChestAPI.getChestLocker();
        if (locker == null) {
            return false;
        }
        if (!locker.isChestLocked(block)) {
            return false;
        }
        locker.removeProtection(block);
        PrivateChest plugin = PrivateChest.getInstance();
        if (plugin != null && plugin.getDataManager() != null) {
            plugin.getDataManager().saveData();
        }
        return true;
    }

    public static UUID getOwner(Block block) {
        if (block == null) {
            throw new IllegalArgumentException("Block cannot be null");
        }
        ChestLocker locker = PrivateChestAPI.getChestLocker();
        if (locker == null) {
            return null;
        }
        String ownerUUID = locker.getOwnerUUID(block);
        if (ownerUUID == null) {
            return null;
        }
        try {
            return UUID.fromString(ownerUUID);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static boolean isLockableContainer(Material material) {
        if (material == null) {
            throw new IllegalArgumentException("Material cannot be null");
        }
        return material == Material.CHEST || material == Material.TRAPPED_CHEST || material == Material.BARREL;
    }

    public static int getLockedChestCount() {
        ChestLocker locker = PrivateChestAPI.getChestLocker();
        if (locker == null) {
            return 0;
        }
        return locker.getChestOwners().size();
    }

    public static boolean isAvailable() {
        return PrivateChest.getInstance() != null && PrivateChestAPI.getChestLocker() != null;
    }

    public static String getVersion() {
        PrivateChest plugin = PrivateChest.getInstance();
        if (plugin == null) {
            return null;
        }
        return plugin.getDescription().getVersion();
    }

    private static ChestLocker getChestLocker() {
        PrivateChest plugin = PrivateChest.getInstance();
        if (plugin == null) {
            return null;
        }
        return ChestLocker.getInstance();
    }
}

