/*
 * Decompiled with CFR 0.152.
 */
package me.tuplugin.privatechest.commands;

import java.util.Set;
import java.util.UUID;
import me.tuplugin.privatechest.MessageManager;
import me.tuplugin.privatechest.PrivateChest;
import me.tuplugin.privatechest.TrustManager;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TrustCommand
implements CommandExecutor {
    private final PrivateChest plugin;
    private final TrustManager trustManager;
    private final MessageManager messages;

    public TrustCommand(PrivateChest plugin) {
        this.plugin = plugin;
        this.trustManager = TrustManager.getInstance();
        this.messages = plugin.getMessageManager();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.messages.raw("console_only_player"));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("privatechest.use")) {
            player.sendMessage(this.messages.raw("no_permission"));
            return true;
        }
        if (args.length == 0) {
            player.sendMessage(this.messages.raw("usage_trust"));
            return true;
        }
        String targetPlayerName = args[0];
        if (targetPlayerName.equalsIgnoreCase("list")) {
            this.showTrustedPlayers(player);
            return true;
        }
        Player targetPlayer = Bukkit.getPlayer((String)targetPlayerName);
        if (targetPlayer == null) {
            player.sendMessage(this.messages.get("player_not_found").replace("{player}", targetPlayerName));
            return true;
        }
        if (player.getUniqueId().equals(targetPlayer.getUniqueId())) {
            player.sendMessage(this.messages.get("cannot_trust_yourself"));
            return true;
        }
        boolean success = this.trustManager.trustPlayer(player, targetPlayer);
        if (success) {
            this.plugin.getDataManager().saveData();
            player.sendMessage(this.messages.get("player_trusted").replace("{player}", targetPlayer.getName()));
            if (targetPlayer.isOnline()) {
                targetPlayer.sendMessage(this.messages.get("trusted_by_player").replace("{player}", player.getName()));
            }
        } else {
            player.sendMessage(this.messages.get("player_already_trusted").replace("{player}", targetPlayer.getName()));
        }
        return true;
    }

    private void showTrustedPlayers(Player player) {
        Set<String> trustedUUIDs = this.trustManager.getTrustedPlayers(player);
        if (trustedUUIDs.isEmpty()) {
            player.sendMessage(this.messages.get("no_trusted_players"));
            return;
        }
        player.sendMessage(this.messages.get("trusted_players_header"));
        for (String uuid : trustedUUIDs) {
            String playerName = this.trustManager.getPlayerName(uuid);
            Player trustedPlayer = Bukkit.getPlayer((UUID)UUID.fromString(uuid));
            String status = trustedPlayer != null && trustedPlayer.isOnline() ? this.messages.raw("player_status_online") : this.messages.raw("player_status_offline");
            player.sendMessage(this.messages.get("trusted_player_entry").replace("{player}", playerName).replace("{status}", status));
        }
        player.sendMessage(this.messages.get("trusted_players_footer").replace("{count}", String.valueOf(trustedUUIDs.size())));
    }
}

