/*
 * Decompiled with CFR 0.152.
 */
package me.tuplugin.privatechest.commands;

import java.util.Set;
import java.util.UUID;
import me.tuplugin.privatechest.MessageManager;
import me.tuplugin.privatechest.PrivateChest;
import me.tuplugin.privatechest.TrustManager;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class UntrustCommand
implements CommandExecutor {
    private final PrivateChest plugin;
    private final TrustManager trustManager;
    private final MessageManager messages;

    public UntrustCommand(PrivateChest plugin) {
        this.plugin = plugin;
        this.trustManager = TrustManager.getInstance();
        this.messages = plugin.getMessageManager();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.messages.raw("console_only_player"));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("privatechest.use")) {
            player.sendMessage(this.messages.raw("no_permission"));
            return true;
        }
        if (args.length == 0) {
            player.sendMessage(this.messages.raw("usage_untrust"));
            return true;
        }
        String targetPlayerName = args[0];
        if (targetPlayerName.equalsIgnoreCase("all")) {
            this.untrustAllPlayers(player);
            return true;
        }
        Player targetPlayer = Bukkit.getPlayer((String)targetPlayerName);
        String targetUUID = null;
        String actualPlayerName = targetPlayerName;
        if (targetPlayer != null) {
            targetUUID = targetPlayer.getUniqueId().toString();
            actualPlayerName = targetPlayer.getName();
        } else {
            Set<String> trustedUUIDs = this.trustManager.getTrustedPlayers(player);
            for (String uuid : trustedUUIDs) {
                String trustedPlayerName = this.trustManager.getPlayerName(uuid);
                if (trustedPlayerName == null || !trustedPlayerName.equalsIgnoreCase(targetPlayerName)) continue;
                targetUUID = uuid;
                actualPlayerName = trustedPlayerName;
                break;
            }
        }
        if (targetUUID == null) {
            player.sendMessage(this.messages.get("player_not_trusted").replace("{player}", targetPlayerName));
            return true;
        }
        boolean success = this.trustManager.untrustPlayer(player.getUniqueId().toString(), targetUUID);
        if (success) {
            this.plugin.getDataManager().saveData();
            player.sendMessage(this.messages.get("player_untrusted").replace("{player}", actualPlayerName));
            if (targetPlayer != null && targetPlayer.isOnline()) {
                targetPlayer.sendMessage(this.messages.get("untrusted_by_player").replace("{player}", player.getName()));
            }
        } else {
            player.sendMessage(this.messages.get("player_not_trusted").replace("{player}", actualPlayerName));
        }
        return true;
    }

    private void untrustAllPlayers(Player player) {
        Set<String> trustedUUIDs = this.trustManager.getTrustedPlayers(player);
        if (trustedUUIDs.isEmpty()) {
            player.sendMessage(this.messages.get("no_trusted_players"));
            return;
        }
        int removedCount = 0;
        for (String uuid : trustedUUIDs) {
            Player trustedPlayer = Bukkit.getPlayer((UUID)UUID.fromString(uuid));
            if (trustedPlayer != null && trustedPlayer.isOnline()) {
                trustedPlayer.sendMessage(this.messages.get("untrusted_by_player").replace("{player}", player.getName()));
            }
            if (!this.trustManager.untrustPlayer(player.getUniqueId().toString(), uuid)) continue;
            ++removedCount;
        }
        if (removedCount > 0) {
            this.plugin.getDataManager().saveData();
            player.sendMessage(this.messages.get("all_players_untrusted").replace("{count}", String.valueOf(removedCount)));
        } else {
            player.sendMessage(this.messages.get("untrust_all_failed"));
        }
    }
}

