/*
 * Decompiled with CFR 0.152.
 */
package me.tuplugin.privatechest.enums;

import org.bukkit.Material;

public enum ContainerType {
    CHEST("chest", Material.CHEST, "Chest"),
    TRAPPED_CHEST("trapped_chest", Material.TRAPPED_CHEST, "Trapped Chest"),
    BARREL("barrel", Material.BARREL, "Barrel"),
    SHULKER_BOX("shulker_box", Material.SHULKER_BOX, "Shulker Box"),
    WHITE_SHULKER_BOX("white_shulker_box", Material.WHITE_SHULKER_BOX, "White Shulker Box"),
    ORANGE_SHULKER_BOX("orange_shulker_box", Material.ORANGE_SHULKER_BOX, "Orange Shulker Box"),
    MAGENTA_SHULKER_BOX("magenta_shulker_box", Material.MAGENTA_SHULKER_BOX, "Magenta Shulker Box"),
    LIGHT_BLUE_SHULKER_BOX("light_blue_shulker_box", Material.LIGHT_BLUE_SHULKER_BOX, "Light Blue Shulker Box"),
    YELLOW_SHULKER_BOX("yellow_shulker_box", Material.YELLOW_SHULKER_BOX, "Yellow Shulker Box"),
    LIME_SHULKER_BOX("lime_shulker_box", Material.LIME_SHULKER_BOX, "Lime Shulker Box"),
    PINK_SHULKER_BOX("pink_shulker_box", Material.PINK_SHULKER_BOX, "Pink Shulker Box"),
    GRAY_SHULKER_BOX("gray_shulker_box", Material.GRAY_SHULKER_BOX, "Gray Shulker Box"),
    LIGHT_GRAY_SHULKER_BOX("light_gray_shulker_box", Material.LIGHT_GRAY_SHULKER_BOX, "Light Gray Shulker Box"),
    CYAN_SHULKER_BOX("cyan_shulker_box", Material.CYAN_SHULKER_BOX, "Cyan Shulker Box"),
    PURPLE_SHULKER_BOX("purple_shulker_box", Material.PURPLE_SHULKER_BOX, "Purple Shulker Box"),
    BLUE_SHULKER_BOX("blue_shulker_box", Material.BLUE_SHULKER_BOX, "Blue Shulker Box"),
    BROWN_SHULKER_BOX("brown_shulker_box", Material.BROWN_SHULKER_BOX, "Brown Shulker Box"),
    GREEN_SHULKER_BOX("green_shulker_box", Material.GREEN_SHULKER_BOX, "Green Shulker Box"),
    RED_SHULKER_BOX("red_shulker_box", Material.RED_SHULKER_BOX, "Red Shulker Box"),
    BLACK_SHULKER_BOX("black_shulker_box", Material.BLACK_SHULKER_BOX, "Black Shulker Box");

    private final String configName;
    private final Material material;
    private final String displayName;

    private ContainerType(String configName, Material material, String displayName) {
        this.configName = configName;
        this.material = material;
        this.displayName = displayName;
    }

    public String getConfigName() {
        return this.configName;
    }

    public Material getMaterial() {
        return this.material;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public ContainerCategory getCategory() {
        switch (this) {
            case CHEST: 
            case TRAPPED_CHEST: {
                return ContainerCategory.CHEST;
            }
            case BARREL: {
                return ContainerCategory.BARREL;
            }
        }
        return ContainerCategory.SHULKER_BOX;
    }

    public static ContainerType fromMaterial(Material material) {
        for (ContainerType type : ContainerType.values()) {
            if (type.getMaterial() != material) continue;
            return type;
        }
        return null;
    }

    public static ContainerType fromConfigName(String configName) {
        if (configName == null) {
            return null;
        }
        for (ContainerType type : ContainerType.values()) {
            if (!type.getConfigName().equalsIgnoreCase(configName)) continue;
            return type;
        }
        return null;
    }

    public static boolean isLockableContainer(Material material) {
        return ContainerType.fromMaterial(material) != null;
    }

    public static enum ContainerCategory {
        CHEST("chest"),
        BARREL("barrel"),
        SHULKER_BOX("shulker_box");

        private final String configName;

        private ContainerCategory(String configName) {
            this.configName = configName;
        }

        public String getConfigName() {
            return this.configName;
        }
    }
}

