/*
 * Decompiled with CFR 0.152.
 */
package me.tuplugin.privatechest.storage;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Set;
import me.tuplugin.privatechest.PrivateChest;
import me.tuplugin.privatechest.storage.DataStorage;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;

public class SqliteStorage
implements DataStorage {
    private final PrivateChest plugin;
    private Connection connection;
    private File databaseFile;
    private static final String TABLE_NAME = "privatechest_data";
    private static final String CREATE_TABLE_SQL = "CREATE TABLE IF NOT EXISTS privatechest_data (id INTEGER PRIMARY KEY AUTOINCREMENT, world TEXT NOT NULL, x INTEGER NOT NULL, y INTEGER NOT NULL, z INTEGER NOT NULL, owner TEXT NOT NULL, password TEXT NOT NULL, UNIQUE(world, x, y, z));";
    private static final String INSERT_SQL = "INSERT OR REPLACE INTO privatechest_data (world, x, y, z, owner, password) VALUES (?, ?, ?, ?, ?, ?)";
    private static final String SELECT_ALL_SQL = "SELECT world, x, y, z, owner, password FROM privatechest_data";
    private static final String DELETE_SQL = "DELETE FROM privatechest_data WHERE world = ? AND x = ? AND y = ? AND z = ?";
    private static final String CLEAR_ALL_SQL = "DELETE FROM privatechest_data";

    public SqliteStorage(PrivateChest plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean initialize() {
        try {
            this.databaseFile = new File(this.plugin.getDataFolder(), "privatechest.db");
            Class.forName("org.sqlite.JDBC");
            String url = "jdbc:sqlite:" + this.databaseFile.getAbsolutePath();
            this.connection = DriverManager.getConnection(url);
            try (Statement stmt = this.connection.createStatement();){
                stmt.execute(CREATE_TABLE_SQL);
            }
            this.plugin.getLogger().info("[PrivateChest] SQLite storage initialized successfully.");
            return true;
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("[PrivateChest] Failed to initialize SQLite storage!");
            e.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean loadData(Map<Location, String> owners, Map<Location, String> passwords) {
        if (!this.isReady()) {
            this.plugin.getLogger().warning("[PrivateChest] SQLite storage is not ready!");
            return false;
        }
        try {
            owners.clear();
            passwords.clear();
            try (Statement stmt = this.connection.createStatement();){
                boolean bl;
                block17: {
                    ResultSet rs = stmt.executeQuery(SELECT_ALL_SQL);
                    try {
                        int loaded = 0;
                        while (rs.next()) {
                            String worldName = rs.getString("world");
                            int x = rs.getInt("x");
                            int y = rs.getInt("y");
                            int z = rs.getInt("z");
                            String owner = rs.getString("owner");
                            String password = rs.getString("password");
                            World world = Bukkit.getWorld((String)worldName);
                            if (world != null) {
                                Location loc = new Location(world, (double)x, (double)y, (double)z);
                                owners.put(loc, owner);
                                passwords.put(loc, password);
                                ++loaded;
                                continue;
                            }
                            this.plugin.getLogger().warning("[PrivateChest] World '" + worldName + "' not found for chest at " + worldName + "," + x + "," + y + "," + z);
                        }
                        this.plugin.getLogger().info("[PrivateChest] Loaded " + loaded + " locked chests from SQLite storage.");
                        bl = true;
                        if (rs == null) break block17;
                    }
                    catch (Throwable throwable) {
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    rs.close();
                }
                return bl;
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("[PrivateChest] Failed to load data from SQLite storage!");
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean saveData(Map<Location, String> owners, Map<Location, String> passwords) {
        if (!this.isReady()) {
            this.plugin.getLogger().warning("[PrivateChest] SQLite storage is not ready!");
            return false;
        }
        try {
            this.connection.setAutoCommit(false);
            try (Statement clearStmt = this.connection.createStatement();){
                clearStmt.execute(CLEAR_ALL_SQL);
            }
            try (PreparedStatement pstmt = this.connection.prepareStatement(INSERT_SQL);){
                for (Map.Entry<Location, String> entry : owners.entrySet()) {
                    Location loc = entry.getKey();
                    String owner = entry.getValue();
                    String password = passwords.get(loc);
                    if (loc.getWorld() == null || password == null) continue;
                    pstmt.setString(1, loc.getWorld().getName());
                    pstmt.setInt(2, loc.getBlockX());
                    pstmt.setInt(3, loc.getBlockY());
                    pstmt.setInt(4, loc.getBlockZ());
                    pstmt.setString(5, owner);
                    pstmt.setString(6, password);
                    pstmt.addBatch();
                }
                pstmt.executeBatch();
            }
            this.connection.commit();
            this.connection.setAutoCommit(true);
            return true;
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("[PrivateChest] Failed to save data to SQLite storage!");
            e.printStackTrace();
            try {
                this.connection.rollback();
                this.connection.setAutoCommit(true);
            }
            catch (SQLException rollbackEx) {
                this.plugin.getLogger().severe("[PrivateChest] Failed to rollback SQLite transaction!");
                rollbackEx.printStackTrace();
            }
            return false;
        }
    }

    @Override
    public void close() {
        if (this.connection != null) {
            try {
                this.connection.close();
                this.plugin.getLogger().info("[PrivateChest] SQLite storage closed successfully.");
            }
            catch (SQLException e) {
                this.plugin.getLogger().warning("[PrivateChest] Error closing SQLite connection: " + e.getMessage());
            }
            finally {
                this.connection = null;
            }
        }
    }

    @Override
    public String getStorageType() {
        return "SQLite";
    }

    @Override
    public boolean isReady() {
        try {
            return this.connection != null && !this.connection.isClosed();
        }
        catch (SQLException e) {
            return false;
        }
    }

    public boolean deleteChest(Location location) {
        boolean bl;
        block9: {
            if (!this.isReady() || location.getWorld() == null) {
                return false;
            }
            PreparedStatement pstmt = this.connection.prepareStatement(DELETE_SQL);
            try {
                pstmt.setString(1, location.getWorld().getName());
                pstmt.setInt(2, location.getBlockX());
                pstmt.setInt(3, location.getBlockY());
                pstmt.setInt(4, location.getBlockZ());
                boolean bl2 = bl = pstmt.executeUpdate() > 0;
                if (pstmt == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (pstmt != null) {
                        try {
                            pstmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    this.plugin.getLogger().warning("[PrivateChest] Failed to delete chest from SQLite: " + e.getMessage());
                    return false;
                }
            }
            pstmt.close();
        }
        return bl;
    }

    public boolean updateChest(Location location, String owner, String password) {
        boolean bl;
        block9: {
            if (!this.isReady() || location.getWorld() == null) {
                return false;
            }
            PreparedStatement pstmt = this.connection.prepareStatement(INSERT_SQL);
            try {
                pstmt.setString(1, location.getWorld().getName());
                pstmt.setInt(2, location.getBlockX());
                pstmt.setInt(3, location.getBlockY());
                pstmt.setInt(4, location.getBlockZ());
                pstmt.setString(5, owner);
                pstmt.setString(6, password);
                boolean bl2 = bl = pstmt.executeUpdate() > 0;
                if (pstmt == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (pstmt != null) {
                        try {
                            pstmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    this.plugin.getLogger().warning("[PrivateChest] Failed to update chest in SQLite: " + e.getMessage());
                    return false;
                }
            }
            pstmt.close();
        }
        return bl;
    }

    @Override
    public boolean loadData(Map<Location, String> owners, Map<Location, String> passwords, Map<Location, String> containerNames, Map<String, Set<String>> trustRelations) {
        return this.loadData(owners, passwords);
    }

    @Override
    public boolean saveData(Map<Location, String> owners, Map<Location, String> passwords, Map<Location, String> containerNames, Map<String, Set<String>> trustRelations) {
        return this.saveData(owners, passwords);
    }
}

