/*
 * Decompiled with CFR 0.152.
 */
package me.tuplugin.privatechest.storage;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.tuplugin.privatechest.PrivateChest;
import me.tuplugin.privatechest.storage.DataStorage;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class YamlStorage
implements DataStorage {
    private final PrivateChest plugin;
    private File dataFile;
    private FileConfiguration dataConfig;

    public YamlStorage(PrivateChest plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean initialize() {
        try {
            this.dataFile = new File(this.plugin.getDataFolder(), "data.yml");
            if (!this.dataFile.exists()) {
                this.dataFile.createNewFile();
                this.plugin.getLogger().info("[PrivateChest] data.yml created.");
            }
            this.dataConfig = YamlConfiguration.loadConfiguration((File)this.dataFile);
            return true;
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("[PrivateChest] Failed to initialize YAML storage!");
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean loadData(Map<Location, String> owners, Map<Location, String> passwords, Map<Location, String> containerNames, Map<String, Set<String>> trustRelations) {
        try {
            ConfigurationSection trustSection;
            ConfigurationSection chestsSection;
            owners.clear();
            passwords.clear();
            if (containerNames != null) {
                containerNames.clear();
            }
            if (trustRelations != null) {
                trustRelations.clear();
            }
            if ((chestsSection = this.dataConfig.getConfigurationSection("chests")) != null) {
                for (String key : chestsSection.getKeys(false)) {
                    String name;
                    Location loc = this.deserializeLocation(key);
                    String owner = this.dataConfig.getString("chests." + key + ".owner");
                    String password = this.dataConfig.getString("chests." + key + ".password");
                    if (loc == null || owner == null || password == null) continue;
                    owners.put(loc, owner);
                    passwords.put(loc, password);
                    if (containerNames == null || (name = this.dataConfig.getString("chests." + key + ".name")) == null || name.trim().isEmpty()) continue;
                    containerNames.put(loc, name.trim());
                }
            }
            if (trustRelations != null && (trustSection = this.dataConfig.getConfigurationSection("trust")) != null) {
                for (String ownerUUID : trustSection.getKeys(false)) {
                    List trustedList = this.dataConfig.getStringList("trust." + ownerUUID);
                    if (trustedList.isEmpty()) continue;
                    trustRelations.put(ownerUUID, new HashSet(trustedList));
                }
            }
            this.plugin.getLogger().info("[PrivateChest] Loaded " + owners.size() + " locked chests from YAML storage.");
            return true;
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("[PrivateChest] Failed to load data from YAML storage!");
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean saveData(Map<Location, String> owners, Map<Location, String> passwords, Map<Location, String> containerNames, Map<String, Set<String>> trustRelations) {
        try {
            this.dataConfig.set("chests", null);
            this.dataConfig.set("trust", null);
            for (Location location : owners.keySet()) {
                String name;
                String path = this.serializeLocation(location);
                if (path == null) continue;
                this.dataConfig.set("chests." + path + ".owner", (Object)owners.get(location));
                this.dataConfig.set("chests." + path + ".password", (Object)passwords.get(location));
                if (containerNames == null || !containerNames.containsKey(location) || (name = containerNames.get(location)) == null || name.trim().isEmpty()) continue;
                this.dataConfig.set("chests." + path + ".name", (Object)name.trim());
            }
            if (trustRelations != null && !trustRelations.isEmpty()) {
                for (Map.Entry entry : trustRelations.entrySet()) {
                    String ownerUUID = (String)entry.getKey();
                    Set trustedUUIDs = (Set)entry.getValue();
                    if (trustedUUIDs.isEmpty()) continue;
                    this.dataConfig.set("trust." + ownerUUID, new ArrayList(trustedUUIDs));
                }
            }
            this.dataConfig.save(this.dataFile);
            return true;
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("[PrivateChest] Could not save data to YAML storage!");
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public void close() {
        this.dataConfig = null;
        this.dataFile = null;
    }

    @Override
    public String getStorageType() {
        return "YAML";
    }

    @Override
    public boolean isReady() {
        return this.dataFile != null && this.dataConfig != null;
    }

    private String serializeLocation(Location loc) {
        if (loc == null || loc.getWorld() == null) {
            this.plugin.getLogger().warning("[PrivateChest] Attempted to save a null location or location with null world. Skipping.");
            return null;
        }
        return loc.getWorld().getName() + "," + loc.getBlockX() + "," + loc.getBlockY() + "," + loc.getBlockZ();
    }

    private Location deserializeLocation(String str) {
        String[] parts = str.split(",");
        if (parts.length != 4) {
            this.plugin.getLogger().warning("[PrivateChest] Malformed location string in data.yml: " + str);
            return null;
        }
        World world = Bukkit.getWorld((String)parts[0]);
        if (world == null) {
            this.plugin.getLogger().warning("[PrivateChest] World '" + parts[0] + "' not found for location in data.yml: " + str);
            return null;
        }
        try {
            int x = Integer.parseInt(parts[1]);
            int y = Integer.parseInt(parts[2]);
            int z = Integer.parseInt(parts[3]);
            return new Location(world, (double)x, (double)y, (double)z);
        }
        catch (NumberFormatException e) {
            this.plugin.getLogger().warning("[PrivateChest] Invalid number format in location from data.yml: " + str);
            return null;
        }
    }
}

