/*
 * Decompiled with CFR 0.152.
 */
package me.tuplugin.privatechest;

import java.util.Iterator;
import me.tuplugin.privatechest.ChestLocker;
import me.tuplugin.privatechest.MessageManager;
import me.tuplugin.privatechest.PrivateChest;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.entity.EntityExplodeEvent;

public class BlockProtectionListener
implements Listener {
    private final PrivateChest plugin;
    private final ChestLocker chestLocker;
    private final MessageManager messages;

    public BlockProtectionListener(PrivateChest plugin) {
        this.plugin = plugin;
        this.chestLocker = ChestLocker.getInstance();
        this.messages = plugin.getMessageManager();
    }

    @EventHandler
    public void onChestBreak(BlockBreakEvent event) {
        Block block = event.getBlock();
        Player player = event.getPlayer();
        if (!this.isLockableContainer(block)) {
            return;
        }
        if (!this.chestLocker.isChestLocked(block)) {
            return;
        }
        if (!this.chestLocker.isOwner(block, player)) {
            event.setCancelled(true);
            player.sendMessage(this.messages.get("not_your_chest"));
        } else {
            player.sendMessage(this.messages.get("chest_break_warning"));
            this.chestLocker.removeProtection(block);
            this.plugin.getDataManager().saveData();
        }
    }

    @EventHandler
    public void onEntityExplode(EntityExplodeEvent event) {
        Iterator it = event.blockList().iterator();
        while (it.hasNext()) {
            Block block = (Block)it.next();
            if (!this.isLockableContainer(block) || !this.chestLocker.isChestLocked(block)) continue;
            it.remove();
        }
    }

    @EventHandler
    public void onBlockExplode(BlockExplodeEvent event) {
        Iterator it = event.blockList().iterator();
        while (it.hasNext()) {
            Block block = (Block)it.next();
            if (!this.isLockableContainer(block) || !this.chestLocker.isChestLocked(block)) continue;
            it.remove();
        }
    }

    private boolean isLockableContainer(Block block) {
        Material type = block.getType();
        return type == Material.CHEST || type == Material.TRAPPED_CHEST || type == Material.BARREL;
    }
}

