/*
 * Decompiled with CFR 0.152.
 */
package me.tuplugin.privatechest;

import me.tuplugin.privatechest.ChestLocker;
import me.tuplugin.privatechest.MessageManager;
import me.tuplugin.privatechest.PrivateChest;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;

public class ChestListener
implements Listener {
    private final PrivateChest plugin;
    private final ChestLocker chestLocker;
    private final MessageManager messages;
    private final FileConfiguration config;

    public ChestListener(PrivateChest plugin) {
        this.plugin = plugin;
        this.chestLocker = ChestLocker.getInstance();
        this.messages = plugin.getMessageManager();
        this.config = plugin.getConfig();
    }

    @EventHandler
    public void onChestInteract(PlayerInteractEvent event) {
        if (event.getClickedBlock() == null || event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block block = event.getClickedBlock();
        Player player = event.getPlayer();
        if (!this.isLockableContainer(block)) {
            return;
        }
        if (!this.chestLocker.isChestLocked(block)) {
            return;
        }
        if (this.chestLocker.isOwner(block, player)) {
            if (this.config.getBoolean("notify-owner-on-open", true)) {
                player.sendMessage(this.messages.get("owner_access_notice"));
            }
            return;
        }
        event.setCancelled(true);
        player.sendMessage(this.messages.get("not_your_chest"));
    }

    private boolean isLockableContainer(Block block) {
        Material type = block.getType();
        return type == Material.CHEST || type == Material.TRAPPED_CHEST || type == Material.BARREL;
    }
}

