/*
 * Decompiled with CFR 0.152.
 */
package me.tuplugin.privatechest;

import java.util.HashMap;
import java.util.Map;
import me.tuplugin.privatechest.PrivateChest;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class ChestLocker {
    private final Map<Location, String> chestOwners = new HashMap<Location, String>();
    private final Map<Location, String> chestPasswords = new HashMap<Location, String>();
    private static ChestLocker instance;

    public ChestLocker(PrivateChest plugin) {
        instance = this;
    }

    public static ChestLocker getInstance() {
        return instance;
    }

    public boolean lockChest(Block block, Player player, String password) {
        Location loc = block.getLocation();
        if (this.chestOwners.containsKey(loc)) {
            return false;
        }
        this.chestOwners.put(loc, player.getUniqueId().toString());
        this.chestPasswords.put(loc, password);
        return true;
    }

    public boolean unlockChest(Block block, Player player, String password) {
        Location loc = block.getLocation();
        if (!this.chestOwners.containsKey(loc)) {
            return false;
        }
        String correctPassword = this.chestPasswords.get(loc);
        return correctPassword != null && correctPassword.equals(password);
    }

    public boolean isChestLocked(Block block) {
        return this.chestOwners.containsKey(block.getLocation());
    }

    public boolean isOwner(Block block, Player player) {
        String ownerUUID = this.chestOwners.get(block.getLocation());
        return ownerUUID != null && ownerUUID.equals(player.getUniqueId().toString());
    }

    public void removeProtection(Block block) {
        Location loc = block.getLocation();
        this.chestOwners.remove(loc);
        this.chestPasswords.remove(loc);
    }

    public Map<Location, String> getChestOwners() {
        return this.chestOwners;
    }

    public Map<Location, String> getChestPasswords() {
        return this.chestPasswords;
    }

    public static String serializeLocation(Location loc) {
        return loc.getWorld().getName() + ":" + loc.getBlockX() + ":" + loc.getBlockY() + ":" + loc.getBlockZ();
    }

    public static Location deserializeLocation(String serialized) {
        String[] parts = serialized.split(":");
        if (parts.length != 4) {
            return null;
        }
        World world = Bukkit.getWorld((String)parts[0]);
        if (world == null) {
            return null;
        }
        try {
            int x = Integer.parseInt(parts[1]);
            int y = Integer.parseInt(parts[2]);
            int z = Integer.parseInt(parts[3]);
            return new Location(world, (double)x, (double)y, (double)z);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

