/*
 * Decompiled with CFR 0.152.
 */
package me.tuplugin.privatechest;

import java.util.Iterator;
import java.util.Map;
import me.tuplugin.privatechest.ChestLocker;
import me.tuplugin.privatechest.DataManager;
import me.tuplugin.privatechest.MessageManager;
import me.tuplugin.privatechest.PrivateChest;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class ClearChestsCommand
implements CommandExecutor {
    private final PrivateChest plugin;
    private final DataManager dataManager;
    private final ChestLocker chestLocker;
    private final MessageManager messages;

    public ClearChestsCommand(PrivateChest plugin) {
        this.plugin = plugin;
        this.dataManager = plugin.getDataManager();
        this.chestLocker = ChestLocker.getInstance();
        this.messages = plugin.getMessageManager();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("privatechest.admin")) {
            sender.sendMessage(this.messages.raw("no_permission"));
            return true;
        }
        int cleared = 0;
        Iterator<Map.Entry<Location, String>> it = this.chestLocker.getChestOwners().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Location, String> entry = it.next();
            Block block = entry.getKey().getBlock();
            if (block != null && this.isLockableContainer(block)) continue;
            it.remove();
            ++cleared;
        }
        this.dataManager.saveData();
        sender.sendMessage(this.messages.raw("cleared_chests").replace("{amount}", String.valueOf(cleared)));
        return true;
    }

    private boolean isLockableContainer(Block block) {
        if (block == null) {
            return false;
        }
        switch (block.getType()) {
            case CHEST: 
            case TRAPPED_CHEST: 
            case BARREL: {
                return true;
            }
        }
        return false;
    }
}

