/*
 * Decompiled with CFR 0.152.
 */
package me.tuplugin.privatechest;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import me.tuplugin.privatechest.ChestLocker;
import me.tuplugin.privatechest.PrivateChest;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class DataManager {
    private final PrivateChest plugin;
    private File dataFile;
    private FileConfiguration dataConfig;

    public DataManager(PrivateChest plugin) {
        this.plugin = plugin;
        this.createDataFile();
        this.loadData();
    }

    private void createDataFile() {
        this.dataFile = new File(this.plugin.getDataFolder(), "data.yml");
        if (!this.dataFile.exists()) {
            try {
                this.dataFile.createNewFile();
                Bukkit.getLogger().info("[PrivateChest] data.yml created.");
            }
            catch (IOException e) {
                Bukkit.getLogger().severe("[PrivateChest] Failed to create data.yml!");
                e.printStackTrace();
            }
        }
        this.dataConfig = YamlConfiguration.loadConfiguration((File)this.dataFile);
    }

    public void loadData() {
        ChestLocker chestLocker = ChestLocker.getInstance();
        if (this.dataConfig.contains("chests")) {
            for (String key : this.dataConfig.getConfigurationSection("chests").getKeys(false)) {
                Location loc = this.deserializeLocation(key);
                String owner = this.dataConfig.getString("chests." + key + ".owner");
                String password = this.dataConfig.getString("chests." + key + ".password");
                if (loc == null || owner == null || password == null) continue;
                chestLocker.getChestOwners().put(loc, owner);
                chestLocker.getChestPasswords().put(loc, password);
            }
        }
        Bukkit.getLogger().info("[PrivateChest] Loaded locked chests.");
    }

    public void saveData() {
        ChestLocker chestLocker = ChestLocker.getInstance();
        Map<Location, String> owners = chestLocker.getChestOwners();
        Map<Location, String> passwords = chestLocker.getChestPasswords();
        this.dataConfig.set("chests", null);
        for (Location loc : owners.keySet()) {
            String path = this.serializeLocation(loc);
            this.dataConfig.set("chests." + path + ".owner", (Object)owners.get(loc));
            this.dataConfig.set("chests." + path + ".password", (Object)passwords.get(loc));
        }
        try {
            this.dataConfig.save(this.dataFile);
        }
        catch (IOException e) {
            Bukkit.getLogger().severe("[PrivateChest] Could not save data.yml!");
            e.printStackTrace();
        }
    }

    private String serializeLocation(Location loc) {
        return loc.getWorld().getName() + "," + loc.getBlockX() + "," + loc.getBlockY() + "," + loc.getBlockZ();
    }

    private Location deserializeLocation(String str) {
        try {
            String[] parts = str.split(",");
            return new Location(Bukkit.getWorld((String)parts[0]), (double)Integer.parseInt(parts[1]), (double)Integer.parseInt(parts[2]), (double)Integer.parseInt(parts[3]));
        }
        catch (Exception e) {
            return null;
        }
    }
}

