/*
 * Decompiled with CFR 0.152.
 */
package me.tuplugin.privatechest;

import me.tuplugin.privatechest.ChestLocker;
import me.tuplugin.privatechest.MessageManager;
import me.tuplugin.privatechest.PrivateChest;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class LockCommand
implements CommandExecutor {
    private final PrivateChest plugin;
    private final ChestLocker chestLocker;
    private final MessageManager messages;

    public LockCommand(PrivateChest plugin) {
        this.plugin = plugin;
        this.chestLocker = ChestLocker.getInstance();
        this.messages = plugin.getMessageManager();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("This command can only be used by players.");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("privatechest.use")) {
            player.sendMessage(this.messages.raw("no_permission"));
            return true;
        }
        if (args.length != 1) {
            player.sendMessage(this.messages.raw("usage_lock"));
            return true;
        }
        String password = args[0];
        Block targetBlock = player.getTargetBlock(null, 5);
        if (targetBlock == null || !this.isLockableContainer(targetBlock)) {
            player.sendMessage(this.messages.get("not_a_chest"));
            return true;
        }
        if (this.chestLocker.isChestLocked(targetBlock)) {
            player.sendMessage(this.messages.get("already_locked"));
            return true;
        }
        boolean success = this.chestLocker.lockChest(targetBlock, player, password);
        if (success) {
            this.plugin.getDataManager().saveData();
            player.sendMessage(this.messages.get("locked"));
        } else {
            player.sendMessage(this.messages.get("already_locked"));
        }
        return true;
    }

    private boolean isLockableContainer(Block block) {
        Material type = block.getType();
        return type == Material.CHEST || type == Material.TRAPPED_CHEST || type == Material.BARREL;
    }
}

