/*
 * Decompiled with CFR 0.152.
 */
package me.tuplugin.privatechest;

import java.io.File;
import me.tuplugin.privatechest.PrivateChest;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class MessageManager {
    private final PrivateChest plugin;
    private FileConfiguration messages;
    private String prefix;
    private boolean usePrefix;

    public MessageManager(PrivateChest plugin) {
        this.plugin = plugin;
        this.loadMessages();
    }

    private void loadMessages() {
        File file = new File(this.plugin.getDataFolder(), "messages.yml");
        if (!file.exists()) {
            this.plugin.saveResource("messages.yml", false);
        }
        this.messages = YamlConfiguration.loadConfiguration((File)file);
        this.reloadPrefix();
    }

    private void reloadPrefix() {
        this.plugin.reloadConfig();
        this.usePrefix = this.plugin.getConfig().getBoolean("use-prefix", true);
        this.prefix = this.translate(this.plugin.getConfig().getString("prefix", "&7[&6PrivateChest&7] "));
    }

    public void reloadMessages() {
        this.loadMessages();
    }

    public String get(String key) {
        String msg = this.messages.getString(key, key);
        if (this.usePrefix) {
            return this.prefix + this.translate(msg);
        }
        return this.translate(msg);
    }

    public String raw(String key) {
        return this.translate(this.messages.getString(key, key));
    }

    private String translate(String text) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)text);
    }
}

