/*
 * Decompiled with CFR 0.152.
 */
package me.tuplugin.privatechest.api;

import java.util.UUID;
import me.tuplugin.privatechest.ChestLocker;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class PrivateChestAPI {
    private static final ChestLocker chestLocker = ChestLocker.getInstance();

    private PrivateChestAPI() {
    }

    public static boolean isLocked(Block block) {
        return chestLocker.isChestLocked(block);
    }

    public static boolean isOwner(Block block, Player player) {
        return chestLocker.isOwner(block, player);
    }

    public static UUID getOwner(Block block) {
        String uuidString = chestLocker.getChestOwners().get(block.getLocation());
        if (uuidString != null) {
            return UUID.fromString(uuidString);
        }
        return null;
    }

    public static boolean lockBlock(Block block, Player player, String password) {
        return chestLocker.lockChest(block, player, password);
    }

    public static void unlockBlock(Block block) {
        chestLocker.removeProtection(block);
    }

    public static String serializeLocation(Location location) {
        return ChestLocker.serializeLocation(location);
    }

    public static Location deserializeLocation(String serialized) {
        return ChestLocker.deserializeLocation(serialized);
    }
}

