/*
 * Decompiled with CFR 0.152.
 */
package net.kasara.ts_multitools.client;

import java.util.HashSet;
import java.util.Objects;
import java.util.UUID;
import net.kasara.ts_multitools.component.ModComponents;
import net.kasara.ts_multitools.item.custom.SlimeItem;
import net.kasara.ts_multitools.network.packet.NewSlimeStackC2SPacket;
import net.kasara.ts_multitools.network.packet.ToggleSlimeModeC2SPacket;
import net.kasara.ts_multitools.util.ModKeyBindings;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1893;
import net.minecraft.class_310;
import net.minecraft.class_6880;
import net.minecraft.class_9304;
import org.lwjgl.glfw.GLFW;

public class SlimeModeClientHandler {
    private static boolean modeTogglePressed = false;

    public static void handleModeToggle(class_310 client) {
        boolean isPressed = ModKeyBindings.MODE_TOGGLE.method_1434();
        if (isPressed && !modeTogglePressed) {
            modeTogglePressed = true;
            class_1799 stack = Objects.requireNonNull(client.field_1724).method_6047();
            if (stack.method_7909() instanceof SlimeItem) {
                UUID stackUuid = (UUID)stack.method_58694(ModComponents.SLIME_UUID);
                boolean ctrlPressed = GLFW.glfwGetKey((long)client.method_22683().method_4490(), (int)341) == 1;
                ToggleSlimeModeC2SPacket.send(stackUuid, ctrlPressed ? "use_mode" : "mining_mode");
            }
        } else if (!isPressed) {
            modeTogglePressed = false;
        }
    }

    public static void updateInventoryEnchantments(class_310 client) {
        class_1661 inv = Objects.requireNonNull(client.field_1724).method_31548();
        HashSet<UUID> seenUUIDs = new HashSet<UUID>();
        for (int i = 0; i < inv.method_5439(); ++i) {
            class_1799 stack = inv.method_5438(i);
            if (stack.method_7960() || !(stack.method_7909() instanceof SlimeItem)) continue;
            UUID stackUuid = (UUID)stack.method_58694(ModComponents.SLIME_UUID);
            if (stackUuid == null || seenUUIDs.contains(stackUuid)) {
                NewSlimeStackC2SPacket.send();
                continue;
            }
            seenUUIDs.add(stackUuid);
            String desiredMode = SlimeModeClientHandler.getMiningModeFromEnchantments(stack);
            ModComponents.SlimeModeComponent mode = (ModComponents.SlimeModeComponent)stack.method_58694(ModComponents.SLIME_MODE);
            if (desiredMode.equals(Objects.requireNonNull(mode).miningMode())) continue;
            ToggleSlimeModeC2SPacket.send(stackUuid, desiredMode);
        }
    }

    private static String getMiningModeFromEnchantments(class_1799 stack) {
        class_9304 enchantments = stack.method_58657();
        if (enchantments == null) {
            return "default";
        }
        boolean hasFortune = enchantments.method_57539().stream().anyMatch(e -> ((class_6880)e.getKey()).method_40225(class_1893.field_9130));
        boolean hasSilkTouch = enchantments.method_57539().stream().anyMatch(e -> ((class_6880)e.getKey()).method_40225(class_1893.field_9099));
        if (hasFortune) {
            return "fortune";
        }
        if (hasSilkTouch) {
            return "silk_touch";
        }
        return "default";
    }
}

