/*
 * Decompiled with CFR 0.152.
 */
package net.kasara.ts_multitools.client;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.kasara.ts_multitools.component.ModComponents;
import net.kasara.ts_multitools.item.ModItems;
import net.kasara.ts_multitools.network.packet.SlimeStateC2SPacket;
import net.kasara.ts_multitools.util.ToolRightClickHandler;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3481;
import net.minecraft.class_636;
import net.minecraft.class_746;
import net.minecraft.class_7923;

public class SlimeStateClientHandler {
    private static final Map<UUID, Integer> slimeTimers = new HashMap<UUID, Integer>();
    private static final Map<UUID, String> slimeStateDuringMining = new HashMap<UUID, String>();
    private static final Map<UUID, String> lastSentMain = new HashMap<UUID, String>();
    private static final Map<UUID, String> lastSentOff = new HashMap<UUID, String>();

    public static void onAttackBlock(class_1657 player, class_1937 world, class_1268 hand, class_2338 pos) {
        class_1799 stack = player.method_5998(hand);
        if (stack.method_7909() != ModItems.SLIME) {
            return;
        }
        UUID uuid = (UUID)stack.method_58694(ModComponents.SLIME_UUID);
        if (uuid == null) {
            return;
        }
        String state = SlimeStateClientHandler.getStateFromBlock(world.method_8320(pos));
        slimeStateDuringMining.put(uuid, state);
        slimeTimers.remove(uuid);
        stack.method_57379(ModComponents.SLIME_STATE, (Object)state);
    }

    public static void updateSlimeStates(class_310 client) {
        class_746 player = client.field_1724;
        if (player == null) {
            return;
        }
        class_1799 mainHand = ((class_1657)Objects.requireNonNull(player)).method_6047();
        class_1799 offHand = player.method_6079();
        class_636 interactionManager = client.field_1761;
        for (class_1799 stack : player.method_31548()) {
            UUID uuid;
            if (stack.method_7909() != ModItems.SLIME || (uuid = (UUID)stack.method_58694(ModComponents.SLIME_UUID)) == null) continue;
            boolean inHand = uuid.equals(mainHand.method_58694(ModComponents.SLIME_UUID)) || uuid.equals(offHand.method_58694(ModComponents.SLIME_UUID));
            String state = "slime";
            if (inHand) {
                if (slimeStateDuringMining.containsKey(uuid)) {
                    state = slimeStateDuringMining.get(uuid);
                    if (!Objects.requireNonNull(interactionManager).method_2923()) {
                        slimeTimers.put(uuid, 40);
                        slimeStateDuringMining.remove(uuid);
                    }
                } else if (slimeTimers.containsKey(uuid) && !"slime".equals(stack.method_58694(ModComponents.SLIME_STATE)) && !"sword".equals(stack.method_58694(ModComponents.SLIME_STATE))) {
                    state = player.field_7495 >= 1 ? (String)stack.method_58695(ModComponents.SLIME_STATE, (Object)"slime") : "slime";
                    int time = slimeTimers.get(uuid) - 1;
                    if (time > 0) {
                        slimeTimers.put(uuid, time);
                    } else {
                        slimeTimers.remove(uuid);
                    }
                } else {
                    state = player.field_7495 >= 1 ? "sword" : "slime";
                    slimeTimers.remove(uuid);
                    slimeStateDuringMining.remove(uuid);
                }
            } else {
                slimeTimers.remove(uuid);
                slimeStateDuringMining.remove(uuid);
                lastSentMain.remove(uuid);
                lastSentOff.remove(uuid);
            }
            stack.method_57379(ModComponents.SLIME_STATE, (Object)state);
            if (stack == mainHand && !Objects.equals(lastSentMain.get(uuid), state)) {
                lastSentMain.put(uuid, state);
                SlimeStateC2SPacket.send(uuid, state);
                continue;
            }
            if (stack != offHand || Objects.equals(lastSentOff.get(uuid), state)) continue;
            lastSentOff.put(uuid, state);
            SlimeStateC2SPacket.send(uuid, state);
        }
    }

    public static void applyStateOnBlockUse(class_1799 stack, ToolRightClickHandler.ToolAction action) {
        if (stack == null || action == null) {
            return;
        }
        UUID uuid = (UUID)stack.method_58694(ModComponents.SLIME_UUID);
        if (uuid == null) {
            return;
        }
        String newState = switch (action) {
            case ToolRightClickHandler.ToolAction.SHOVEL -> "shovel";
            case ToolRightClickHandler.ToolAction.AXE -> "axe";
            case ToolRightClickHandler.ToolAction.HOE -> "hoe";
            default -> "sword";
        };
        slimeStateDuringMining.put(uuid, newState);
        slimeTimers.remove(uuid);
        stack.method_57379(ModComponents.SLIME_STATE, (Object)newState);
    }

    private static String getStateFromBlock(class_2680 blockState) {
        if (blockState.method_26164(class_3481.field_33715) || class_7923.field_41175.method_10221((Object)blockState.method_26204()).method_12832().contains("glass")) {
            return "pickaxe";
        }
        if (blockState.method_26164(class_3481.field_33713)) {
            return "axe";
        }
        if (blockState.method_26164(class_3481.field_33716)) {
            return "shovel";
        }
        if (blockState.method_26164(class_3481.field_33714)) {
            return "hoe";
        }
        return "sword";
    }
}

