/*
 * Decompiled with CFR 0.152.
 */
package net.kasara.ts_multitools.item.custom;

import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.item.v1.EnchantingContext;
import net.kasara.ts_multitools.client.ModClientData;
import net.kasara.ts_multitools.client.SlimeStateClientHandler;
import net.kasara.ts_multitools.component.ModComponents;
import net.kasara.ts_multitools.entity.ModEntities;
import net.kasara.ts_multitools.entity.custom.SlimeArrowEntity;
import net.kasara.ts_multitools.util.ModTags;
import net.kasara.ts_multitools.util.OffhandTriggerTracker;
import net.kasara.ts_multitools.util.SlimeUseCountUtil;
import net.kasara.ts_multitools.util.ToolRightClickHandler;
import net.kasara.ts_multitools.util.ToolUtil;
import net.minecraft.class_10712;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1753;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1814;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3902;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9334;
import net.minecraft.class_9886;

public class SlimeItem
extends class_1753 {
    public SlimeItem(class_9886 material, class_1792.class_1793 settings) {
        super(ToolUtil.applyMultiToolSettings(material, settings.method_7889(1).method_24359().method_7894(class_1814.field_8904).method_57349(ModComponents.SLIME_STATE, (Object)"slime").method_57349(ModComponents.SLIME_MODE, (Object)new ModComponents.SlimeModeComponent("bow", "default")).method_57349(ModComponents.MINING_ENCHANT, (Object)new ModComponents.MiningEnchantComponent(3, 1)), ModTags.Blocks.SLIME_MINEABLE, 3.0f, -2.4f));
    }

    public class_1269 method_7884(class_1838 context) {
        boolean targetingBlock;
        class_1657 player = context.method_8036();
        if (player == null || player.field_7495 < 1) {
            return class_1269.field_5811;
        }
        class_1799 stack = context.method_8041();
        ModComponents.SlimeModeComponent mode = (ModComponents.SlimeModeComponent)stack.method_58694(ModComponents.SLIME_MODE);
        if (mode != null && "tool".equals(mode.useMode())) {
            ToolRightClickHandler.ToolAction action = ToolRightClickHandler.handleRightClick(context);
            if (action != ToolRightClickHandler.ToolAction.NONE) {
                if (player.method_37908().field_9236) {
                    SlimeStateClientHandler.applyStateOnBlockUse(stack, action);
                }
                SlimeUseCountUtil.increment(player);
                SlimeItem.shouldConsumeXP(player);
            }
            return action != ToolRightClickHandler.ToolAction.NONE ? class_1269.field_5812 : class_1269.field_5811;
        }
        class_1799 offHandStack = player.method_6079();
        String id = class_7923.field_41178.method_10221((Object)offHandStack.method_7909()).toString();
        boolean forbiddenOffhand = id.contains("torch") || id.contains("storagebox");
        boolean bl = targetingBlock = !context.method_8045().method_8320(context.method_8037()).method_26215();
        if (targetingBlock && forbiddenOffhand) {
            OffhandTriggerTracker.set(player, true);
            return class_1269.field_5811;
        }
        OffhandTriggerTracker.clear(player);
        return class_1269.field_5811;
    }

    public class_1269 method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (user.field_7495 < 1) {
            return class_1269.field_5814;
        }
        class_1799 stack = user.method_5998(hand);
        ModComponents.SlimeModeComponent mode = (ModComponents.SlimeModeComponent)stack.method_58694(ModComponents.SLIME_MODE);
        if (mode != null && "tool".equals(mode.useMode())) {
            return class_1269.field_5814;
        }
        if (OffhandTriggerTracker.get(user)) {
            OffhandTriggerTracker.clear(user);
            return class_1269.field_5814;
        }
        user.method_6019(hand);
        return class_1269.field_21466;
    }

    public boolean method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        if (!(user instanceof class_1657)) {
            return false;
        }
        class_1657 playerEntity = (class_1657)user;
        int useTime = this.method_7881(stack, user) - remainingUseTicks;
        float pullProgress = SlimeItem.method_7722((int)useTime);
        if ((double)pullProgress < 0.1) {
            return false;
        }
        class_1799 dummyArrow = new class_1799((class_1935)class_1802.field_8107);
        dummyArrow.method_57379(class_9334.field_49642, (Object)class_3902.field_17274);
        List<class_1799> projectiles = List.of(dummyArrow);
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            this.method_57393(serverWorld, (class_1309)playerEntity, playerEntity.method_6058(), stack, projectiles, pullProgress * 3.0f, 1.0f, pullProgress == 1.0f, null);
        }
        world.method_43128(null, playerEntity.method_23317(), playerEntity.method_23318(), playerEntity.method_23321(), class_3417.field_14600, class_3419.field_15248, 1.0f, 1.0f / (world.method_8409().method_43057() * 0.4f + 1.2f) + pullProgress * 0.5f);
        SlimeUseCountUtil.increment(playerEntity);
        SlimeItem.shouldConsumeXP(playerEntity);
        playerEntity.method_7259(class_3468.field_15372.method_14956((Object)this));
        return true;
    }

    protected class_1676 method_57344(class_1937 world, class_1309 shooter, class_1799 weaponStack, class_1799 projectileStack, boolean critical) {
        SlimeArrowEntity arrow = new SlimeArrowEntity(ModEntities.SLIME_ARROW, shooter, world, projectileStack, weaponStack);
        arrow.method_7439(critical);
        return arrow;
    }

    public boolean method_7879(class_1799 stack, class_1937 world, class_2680 state, class_2338 pos, class_1309 miner) {
        if (!(miner instanceof class_1657)) {
            return false;
        }
        class_1657 player = (class_1657)miner;
        SlimeUseCountUtil.increment(player);
        SlimeItem.shouldConsumeXP(player);
        return super.method_7879(stack, world, state, pos, miner);
    }

    public void method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        if (attacker instanceof class_1657) {
            class_1657 player = (class_1657)attacker;
            SlimeUseCountUtil.increment(player);
            SlimeItem.shouldConsumeXP(player);
            super.method_7873(stack, target, attacker);
        }
    }

    public float method_58404(class_1799 stack, class_2680 state) {
        class_2960 id = class_7923.field_41175.method_10221((Object)state.method_26204());
        if (id.method_12832().contains("glass")) {
            return 1.5f;
        }
        return super.method_58404(stack, state);
    }

    public boolean canBeEnchantedWith(class_1799 stack, class_6880<class_1887> enchantment, EnchantingContext context) {
        if (!super.canBeEnchantedWith(stack, enchantment, context)) {
            return false;
        }
        return !enchantment.method_40225(class_1893.field_9119) && !enchantment.method_40225(class_1893.field_9101) && !enchantment.method_40225(class_1893.field_9125);
    }

    public void method_67187(class_1799 stack, class_1792.class_9635 context, class_10712 displayComponent, Consumer<class_2561> textConsumer, class_1836 type) {
        super.method_67187(stack, context, displayComponent, textConsumer, type);
        textConsumer.accept((class_2561)class_2561.method_43469((String)"tooltip.tokorotenslime.proficiency", (Object[])new Object[]{ModClientData.getSlimeUseCount()}));
        ModComponents.SlimeModeComponent mode = (ModComponents.SlimeModeComponent)stack.method_58694(ModComponents.SLIME_MODE);
        if (mode != null) {
            class_5250 miningText = class_2561.method_43471((String)("mode.tokorotenslime.mining." + mode.miningMode()));
            textConsumer.accept((class_2561)class_2561.method_43469((String)"tooltip.tokorotenslime.mining_mode", (Object[])new Object[]{miningText}).method_10862(class_2583.field_24360.method_10977(class_124.field_1075)));
            class_5250 modeText = class_2561.method_43471((String)("mode.tokorotenslime.use." + mode.useMode()));
            textConsumer.accept((class_2561)class_2561.method_43469((String)"tooltip.tokorotenslime.use_mode", (Object[])new Object[]{modeText}).method_10862(class_2583.field_24360.method_10977(class_124.field_1065)));
        }
    }

    private static void shouldConsumeXP(class_1657 player) {
        boolean consume;
        if (player.method_37908().field_9236) {
            return;
        }
        int count = SlimeUseCountUtil.get(player);
        double probability = Math.max(1.0 - (double)count / 50000.0 * 0.8, 0.2);
        boolean bl = consume = player.method_37908().field_9229.method_43058() < probability;
        if (consume) {
            ((class_3222)player).method_7255(-1);
        }
    }
}

