/*
 * Decompiled with CFR 0.152.
 */
package net.kasara.ts_multitools.server;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.UUID;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.kasara.ts_multitools.TSMultitools;
import net.kasara.ts_multitools.component.ModComponents;
import net.kasara.ts_multitools.item.ModItems;
import net.kasara.ts_multitools.item.custom.SlimeItem;
import net.kasara.ts_multitools.network.packet.SlimeUseCountS2CPacket;
import net.kasara.ts_multitools.server.ModServerData;
import net.kasara.ts_multitools.server.SlimeModeServerHandler;
import net.kasara.ts_multitools.util.SlimeUseCountUtil;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2596;
import net.minecraft.class_2744;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class ModServerEvents {
    public static void registerEvents() {
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> SlimeUseCountS2CPacket.send(handler.method_32311(), SlimeUseCountUtil.get((class_1657)handler.method_32311())));
        AttackBlockCallback.EVENT.register((playerEntity, world, hand, blockPos, direction) -> {
            if (ModServerEvents.shouldCancelAttack(playerEntity, hand)) {
                return class_1269.field_5814;
            }
            return class_1269.field_5811;
        });
        AttackEntityCallback.EVENT.register((player, world, hand, entity, hitResult) -> {
            class_1799 stack = player.method_5998(hand);
            if (stack.method_7909() != ModItems.SLIME) {
                return class_1269.field_5811;
            }
            if (player.field_7495 < 1) {
                return class_1269.field_5814;
            }
            if (world.method_8608()) {
                stack.method_57379(ModComponents.SLIME_STATE, (Object)"sword");
            }
            return class_1269.field_5811;
        });
        ServerPlayerEvents.COPY_FROM.register((oldPlayer, newPlayer, alive) -> {
            int oldCount = SlimeUseCountUtil.get((class_1657)oldPlayer);
            SlimeUseCountUtil.set((class_1657)newPlayer, oldCount);
        });
        TSMultitools.LOGGER.info("Registering addon Mod Server Events for tokorotenslime (from ts_multitools)");
    }

    private static boolean shouldCancelAttack(class_1657 player, class_1268 hand) {
        if (hand == class_1268.field_5808) {
            class_1799 stack = player.method_6047();
            return stack.method_7909() instanceof SlimeItem && player.field_7495 <= 0;
        }
        return false;
    }

    public static void onSlimeStateUpdate(UUID uuid, String state, class_3222 other) {
        MinecraftServer server = other.method_51469().method_8503();
        Objects.requireNonNull(server).execute(() -> {
            class_1661 inv = other.method_31548();
            for (int i = 0; i < inv.method_5439(); ++i) {
                UUID invUuid;
                class_1799 stack = inv.method_5438(i);
                if (stack.method_7960() || !(stack.method_7909() instanceof SlimeItem) || (invUuid = (UUID)stack.method_58694(ModComponents.SLIME_UUID)) == null || !invUuid.equals(uuid)) continue;
                stack.method_57379(ModComponents.SLIME_STATE, (Object)"slime");
            }
            ModServerData.setSlimeState(uuid, state);
            class_1799 mainHand = other.method_6047();
            class_1799 offHand = other.method_6079();
            ArrayList<Pair> equipment = new ArrayList<Pair>();
            if (mainHand.method_7909() == ModItems.SLIME) {
                equipment.add(new Pair((Object)class_1304.field_6173, (Object)mainHand));
            }
            if (offHand.method_7909() == ModItems.SLIME) {
                equipment.add(new Pair((Object)class_1304.field_6171, (Object)offHand));
            }
            if (equipment.isEmpty()) {
                return;
            }
            class_2744 packet = new class_2744(other.method_5628(), equipment);
            for (class_3222 player : server.method_3760().method_14571()) {
                if (other == player) continue;
                player.field_13987.method_14364((class_2596)packet);
            }
        });
    }

    public static void assignUUIDToNewSlimes(class_3222 player) {
        MinecraftServer server = player.method_5682();
        Objects.requireNonNull(server).execute(() -> {
            class_1661 inv = player.method_31548();
            HashSet<UUID> seenUUIDs = new HashSet<UUID>();
            for (int i = 0; i < inv.method_5439(); ++i) {
                class_1799 stack = inv.method_5438(i);
                if (stack.method_7960() || !(stack.method_7909() instanceof SlimeItem)) continue;
                UUID stackUuid = (UUID)stack.method_58694(ModComponents.SLIME_UUID);
                if (stackUuid == null || seenUUIDs.contains(stackUuid)) {
                    UUID newUuid = UUID.randomUUID();
                    stack.method_57379(ModComponents.SLIME_UUID, (Object)newUuid);
                    stackUuid = newUuid;
                }
                seenUUIDs.add(stackUuid);
            }
        });
    }

    public static void toggleSlimeModeHandle(UUID stackUuid, String mode, class_3222 player) {
        MinecraftServer server = player.method_5682();
        Objects.requireNonNull(server).execute(() -> {
            switch (mode) {
                case "use_mode": {
                    SlimeModeServerHandler.handleUseMode(player);
                    break;
                }
                case "mining_mode": {
                    SlimeModeServerHandler.handleMiningMode(player);
                    break;
                }
                case "fortune": 
                case "silk_touch": 
                case "default": {
                    SlimeModeServerHandler.updateMiningModeForInventory(stackUuid, mode, player);
                }
            }
        });
    }
}

