/*
 * Decompiled with CFR 0.152.
 */
package net.kasara.ts_multitools.server;

import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.kasara.ts_multitools.component.ModComponents;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1893;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9304;
import net.minecraft.class_9334;

public class SlimeModeServerHandler {
    public static void handleUseMode(class_3222 player) {
        class_1799 stack = player.method_6047();
        ModComponents.SlimeModeComponent comp = (ModComponents.SlimeModeComponent)stack.method_58694(ModComponents.SLIME_MODE);
        if (comp == null) {
            return;
        }
        String newUseMode = comp.useMode().equals("bow") ? "tool" : "bow";
        ModComponents.SlimeModeComponent newComp = comp.withUseMode(newUseMode);
        stack.method_57379(ModComponents.SLIME_MODE, (Object)newComp);
        class_5250 modeText = class_2561.method_43471((String)("mode.tokorotenslime.use." + newUseMode)).method_10862(class_2583.field_24360.method_10977(class_124.field_1065));
        player.method_7353((class_2561)class_2561.method_43469((String)"message.tokorotenslime.use_mode", (Object[])new Object[]{modeText}), false);
    }

    public static void handleMiningMode(class_3222 player) {
        String newMiningMode;
        class_1799 stack = player.method_6047();
        ModComponents.SlimeModeComponent comp = (ModComponents.SlimeModeComponent)stack.method_58694(ModComponents.SLIME_MODE);
        if (comp == null) {
            return;
        }
        switch (comp.miningMode()) {
            case "fortune": {
                String string = "silk_touch";
                break;
            }
            case "silk_touch": {
                String string = "fortune";
                break;
            }
            default: {
                String string = newMiningMode = "default";
            }
        }
        if (newMiningMode.equals("default")) {
            return;
        }
        class_5455.class_6890 registryManager = Objects.requireNonNull(player.method_5682()).method_30611();
        Optional enchantmentRegistryOpt = registryManager.method_46759(class_7924.field_41265);
        if (enchantmentRegistryOpt.isEmpty()) {
            return;
        }
        class_2378 enchantmentRegistry = (class_2378)enchantmentRegistryOpt.get();
        Optional fortuneEntryOpt = enchantmentRegistry.method_10223(class_1893.field_9130.method_29177());
        Optional silkEntryOpt = enchantmentRegistry.method_10223(class_1893.field_9099.method_29177());
        if (fortuneEntryOpt.isEmpty() || silkEntryOpt.isEmpty()) {
            return;
        }
        class_6880 fortuneEntry = (class_6880)fortuneEntryOpt.get();
        class_6880 silkEntry = (class_6880)silkEntryOpt.get();
        class_9304 current = (class_9304)stack.method_58695(class_9334.field_49633, (Object)class_9304.field_49385);
        int currentFortune = current.method_57536(fortuneEntry);
        int currentSilk = current.method_57536(silkEntry);
        ModComponents.MiningEnchantComponent miningComp = (ModComponents.MiningEnchantComponent)stack.method_58694(ModComponents.MINING_ENCHANT);
        if (miningComp == null) {
            return;
        }
        int storedFortune = miningComp.fortuneLevel();
        int storedSilk = miningComp.silkTouchLevel();
        if (currentFortune > 0 && currentFortune > storedFortune) {
            miningComp = miningComp.withFortune(currentFortune);
        }
        if (currentSilk > 0 && currentSilk > storedSilk) {
            miningComp = miningComp.withSilkTouch(currentSilk);
        }
        stack.method_57379(ModComponents.MINING_ENCHANT, (Object)miningComp);
        class_9304.class_9305 enchBuilder = new class_9304.class_9305(current);
        enchBuilder.method_57548(entry -> entry.equals((Object)fortuneEntry) || entry.equals((Object)silkEntry));
        if (newMiningMode.equals("fortune") && miningComp.fortuneLevel() > 0) {
            enchBuilder.method_57550(fortuneEntry, miningComp.fortuneLevel());
        } else if (newMiningMode.equals("silk_touch") && miningComp.silkTouchLevel() > 0) {
            enchBuilder.method_57550(silkEntry, miningComp.silkTouchLevel());
        }
        stack.method_57379(class_9334.field_49633, (Object)enchBuilder.method_57549());
        stack.method_57379(ModComponents.SLIME_MODE, (Object)comp.withMiningMode(newMiningMode));
        class_5250 miningText = class_2561.method_43471((String)("mode.tokorotenslime.mining." + newMiningMode)).method_10862(class_2583.field_24360.method_10977(class_124.field_1075));
        player.method_7353((class_2561)class_2561.method_43469((String)"message.tokorotenslime.mining_mode", (Object[])new Object[]{miningText}), false);
    }

    public static void updateMiningModeForInventory(UUID stackUuid, String mode, class_3222 player) {
        class_1661 inventory = player.method_31548();
        for (int i = 0; i < inventory.method_5439(); ++i) {
            ModComponents.SlimeModeComponent comp;
            UUID uuidComp;
            class_1799 stack = inventory.method_5438(i);
            if (stack.method_7960() || (uuidComp = (UUID)stack.method_58694(ModComponents.SLIME_UUID)) == null || !uuidComp.equals(stackUuid) || (comp = (ModComponents.SlimeModeComponent)stack.method_58694(ModComponents.SLIME_MODE)) == null) continue;
            ModComponents.SlimeModeComponent newComp = comp.withMiningMode(mode);
            stack.method_57379(ModComponents.SLIME_MODE, (Object)newComp);
        }
    }
}

