/*
 * Decompiled with CFR 0.152.
 */
package net.kasara.ts_multitools.util;

import com.google.common.collect.BiMap;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1838;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2465;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3922;
import net.minecraft.class_5712;
import net.minecraft.class_5953;
import net.minecraft.class_5955;
import net.minecraft.class_6880;

public class ToolRightClickHandler {
    private static final Map<class_2248, class_2680> PATH_STATES = Map.ofEntries(Map.entry(class_2246.field_10219, class_2246.field_10194.method_9564()), Map.entry(class_2246.field_10566, class_2246.field_10194.method_9564()), Map.entry(class_2246.field_10520, class_2246.field_10194.method_9564()), Map.entry(class_2246.field_10253, class_2246.field_10194.method_9564()), Map.entry(class_2246.field_10402, class_2246.field_10194.method_9564()), Map.entry(class_2246.field_28685, class_2246.field_10194.method_9564()));
    private static final Map<class_2248, Pair<Predicate<class_1838>, Consumer<class_1838>>> TILLING_ACTIONS = Map.of(class_2246.field_10219, Pair.of(ToolRightClickHandler::canTillFarmland, ToolRightClickHandler.createTillAction(class_2246.field_10362.method_9564())), class_2246.field_10194, Pair.of(ToolRightClickHandler::canTillFarmland, ToolRightClickHandler.createTillAction(class_2246.field_10362.method_9564())), class_2246.field_10566, Pair.of(ToolRightClickHandler::canTillFarmland, ToolRightClickHandler.createTillAction(class_2246.field_10362.method_9564())), class_2246.field_10253, Pair.of(ToolRightClickHandler::canTillFarmland, ToolRightClickHandler.createTillAction(class_2246.field_10566.method_9564())), class_2246.field_28685, Pair.of(ctx -> true, ToolRightClickHandler.createTillAndDropAction(class_2246.field_10566.method_9564(), (class_1935)class_1802.field_28656)));
    private static final Map<class_2248, class_2248> STRIPPED_BLOCKS = Map.ofEntries(Map.entry(class_2246.field_10126, class_2246.field_10250), Map.entry(class_2246.field_10431, class_2246.field_10519), Map.entry(class_2246.field_10178, class_2246.field_10374), Map.entry(class_2246.field_10010, class_2246.field_10244), Map.entry(class_2246.field_10155, class_2246.field_10558), Map.entry(class_2246.field_10037, class_2246.field_10436), Map.entry(class_2246.field_10307, class_2246.field_10204), Map.entry(class_2246.field_10511, class_2246.field_10366), Map.entry(class_2246.field_10303, class_2246.field_10084), Map.entry(class_2246.field_10306, class_2246.field_10254), Map.entry(class_2246.field_9999, class_2246.field_10103), Map.entry(class_2246.field_10533, class_2246.field_10622), Map.entry(class_2246.field_37549, class_2246.field_37550), Map.entry(class_2246.field_37545, class_2246.field_37548), Map.entry(class_2246.field_54734, class_2246.field_54713), Map.entry(class_2246.field_54715, class_2246.field_54716), Map.entry(class_2246.field_42733, class_2246.field_42730), Map.entry(class_2246.field_42729, class_2246.field_42732), Map.entry(class_2246.field_22111, class_2246.field_22112), Map.entry(class_2246.field_22503, class_2246.field_22504), Map.entry(class_2246.field_22118, class_2246.field_22119), Map.entry(class_2246.field_22505, class_2246.field_22506), Map.entry(class_2246.field_41072, class_2246.field_41073));

    public static ToolAction handleRightClick(class_1838 context) {
        class_1657 player = context.method_8036();
        if (player != null && player.method_5715() && ToolRightClickHandler.tryHoeAction(context)) {
            return ToolAction.HOE;
        }
        if (ToolRightClickHandler.tryShovelAction(context)) {
            return ToolAction.SHOVEL;
        }
        if (ToolRightClickHandler.tryAxeAction(context)) {
            return ToolAction.AXE;
        }
        return ToolAction.NONE;
    }

    private static boolean tryShovelAction(class_1838 context) {
        class_1937 world = context.method_8045();
        class_2338 pos = context.method_8037();
        class_2680 state = world.method_8320(pos);
        if (context.method_8038() == class_2350.field_11033) {
            return false;
        }
        class_2680 flattened = PATH_STATES.get(state.method_26204());
        class_2680 newState = null;
        if (flattened != null && world.method_8320(pos.method_10084()).method_26215()) {
            world.method_8396((class_1297)context.method_8036(), pos, class_3417.field_14616, class_3419.field_15245, 1.0f, 1.0f);
            newState = flattened;
        } else if (state.method_26204() instanceof class_3922 && ((Boolean)state.method_11654((class_2769)class_3922.field_17352)).booleanValue()) {
            if (!world.method_8608()) {
                world.method_8444(null, 1009, pos, 0);
            }
            class_3922.method_29288((class_1297)context.method_8036(), (class_1936)world, (class_2338)pos, (class_2680)state);
            newState = (class_2680)state.method_11657((class_2769)class_3922.field_17352, (Comparable)Boolean.valueOf(false));
        }
        if (newState != null) {
            if (!world.field_9236) {
                world.method_8652(pos, newState, 11);
                world.method_43276((class_6880)class_5712.field_28733, pos, class_5712.class_7397.method_43286((class_1297)context.method_8036(), (class_2680)newState));
                ToolRightClickHandler.damageTool(context);
            }
            return true;
        }
        return false;
    }

    private static boolean tryHoeAction(class_1838 context) {
        class_2338 pos;
        class_1937 world = context.method_8045();
        Pair<Predicate<class_1838>, Consumer<class_1838>> pair = TILLING_ACTIONS.get(world.method_8320(pos = context.method_8037()).method_26204());
        if (pair == null) {
            return false;
        }
        if (((Predicate)pair.getFirst()).test(context)) {
            world.method_8396((class_1297)context.method_8036(), pos, class_3417.field_14846, class_3419.field_15245, 1.0f, 1.0f);
            if (!world.field_9236) {
                ((Consumer)pair.getSecond()).accept(context);
                ToolRightClickHandler.damageTool(context);
            }
            return true;
        }
        return false;
    }

    private static boolean tryAxeAction(class_1838 context) {
        class_1937 world = context.method_8045();
        class_2338 pos = context.method_8037();
        class_2680 state = world.method_8320(pos);
        class_1657 playerEntity = context.method_8036();
        class_1799 itemStack = context.method_8041();
        class_2680 newState = null;
        class_2248 stripped = STRIPPED_BLOCKS.get(state.method_26204());
        if (stripped != null) {
            newState = (class_2680)stripped.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)((class_2350.class_2351)state.method_11654((class_2769)class_2465.field_11459)));
            world.method_8396((class_1297)context.method_8036(), pos, class_3417.field_14675, class_3419.field_15245, 1.0f, 1.0f);
        } else {
            Optional oxState = class_5955.method_34735((class_2680)state);
            if (oxState.isPresent()) {
                newState = (class_2680)oxState.get();
                world.method_8396((class_1297)context.method_8036(), pos, class_3417.field_29541, class_3419.field_15245, 1.0f, 1.0f);
                world.method_8444((class_1297)context.method_8036(), 3005, pos, 0);
            } else {
                Optional<class_2680> waxedState = Optional.ofNullable((class_2248)((BiMap)class_5953.field_29561.get()).get((Object)state.method_26204())).map(block -> block.method_34725(state));
                if (waxedState.isPresent()) {
                    newState = waxedState.get();
                    world.method_8396((class_1297)context.method_8036(), pos, class_3417.field_29542, class_3419.field_15245, 1.0f, 1.0f);
                    world.method_8444((class_1297)context.method_8036(), 3004, pos, 0);
                }
            }
        }
        if (newState != null) {
            if (!world.field_9236) {
                if (playerEntity instanceof class_3222) {
                    class_174.field_24478.method_23889((class_3222)playerEntity, pos, itemStack);
                }
                world.method_8652(pos, newState, 11);
                world.method_43276((class_6880)class_5712.field_28733, pos, class_5712.class_7397.method_43286((class_1297)context.method_8036(), (class_2680)newState));
                ToolRightClickHandler.damageTool(context);
            }
            return true;
        }
        return false;
    }

    private static void damageTool(class_1838 context) {
        class_1799 stack = context.method_8041();
        class_1657 player = context.method_8036();
        if (player != null) {
            stack.method_7970(1, (class_1309)player, class_1309.method_56079((class_1268)context.method_20287()));
        }
    }

    private static boolean canTillFarmland(class_1838 context) {
        return context.method_8038() != class_2350.field_11033 && context.method_8045().method_8320(context.method_8037().method_10084()).method_26215();
    }

    private static Consumer<class_1838> createTillAction(class_2680 result) {
        return context -> {
            context.method_8045().method_8652(context.method_8037(), result, 11);
            context.method_8045().method_43276((class_6880)class_5712.field_28733, context.method_8037(), class_5712.class_7397.method_43286((class_1297)context.method_8036(), (class_2680)result));
        };
    }

    private static Consumer<class_1838> createTillAndDropAction(class_2680 result, class_1935 drop) {
        return context -> {
            context.method_8045().method_8652(context.method_8037(), result, 11);
            context.method_8045().method_43276((class_6880)class_5712.field_28733, context.method_8037(), class_5712.class_7397.method_43286((class_1297)context.method_8036(), (class_2680)result));
            class_2248.method_36992((class_1937)context.method_8045(), (class_2338)context.method_8037(), (class_2350)context.method_8038(), (class_1799)new class_1799(drop));
        };
    }

    public static enum ToolAction {
        SHOVEL,
        HOE,
        AXE,
        NONE;

    }
}

