/*
 * Decompiled with CFR 0.152.
 */
package net.splinter.seedpackages.item;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.splinter.seedpackages.procedures.OpenSeedPackageFarmProcedure;
import net.splinter.seedpackages.procedures.PackageFillProcedure;
import net.splinter.seedpackages.procedures.ReturnPackageContentProcedure;

public class SeedPackageFarmOpenItem
extends Item {
    public SeedPackageFarmOpenItem() {
        super(new Item.Properties().durability(64));
    }

    public UseAnim getUseAnimation(ItemStack itemstack) {
        return UseAnim.BOW;
    }

    public int getUseDuration(ItemStack itemstack, LivingEntity livingEntity) {
        return 20;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        Entity entity = itemstack.getEntityRepresentation() != null ? itemstack.getEntityRepresentation() : Minecraft.getInstance().player;
        String hoverText = ReturnPackageContentProcedure.execute(itemstack);
        if (hoverText != null) {
            for (String line : hoverText.split("\n")) {
                list.add((Component)Component.literal((String)line));
            }
        }
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player entity, InteractionHand hand) {
        InteractionResultHolder ar = super.use(world, entity, hand);
        entity.startUsingItem(hand);
        return ar;
    }

    public ItemStack finishUsingItem(ItemStack itemstack, Level world, LivingEntity entity) {
        ItemStack retval = super.finishUsingItem(itemstack, world, entity);
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        OpenSeedPackageFarmProcedure.execute((Entity)entity, itemstack);
        return retval;
    }

    public boolean onEntitySwing(ItemStack itemstack, LivingEntity entity, InteractionHand hand) {
        boolean retval = super.onEntitySwing(itemstack, entity, hand);
        PackageFillProcedure.execute((LevelAccessor)entity.level(), (Entity)entity, itemstack);
        return retval;
    }
}

