/*
 * Decompiled with CFR 0.152.
 */
package com.spicymike.ipwhitelist;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class IPWhitelistPlugin
extends JavaPlugin
implements Listener,
TabExecutor {
    private File whitelistFile;
    private FileConfiguration whitelistConfig;
    private Set<String> whitelistedIPs;
    private boolean whitelistEnabled;
    private String kickMessage;

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfigValues();
        this.loadWhitelist();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getCommand("ipwhitelist").setExecutor((CommandExecutor)this);
    }

    private void loadConfigValues() {
        this.whitelistEnabled = this.getConfig().getBoolean("whitelist-enabled", true);
        this.kickMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("kick-message", "&cYour IP is not whitelisted."));
    }

    private void loadWhitelist() {
        this.whitelistFile = new File(this.getDataFolder(), "whitelist.yml");
        if (!this.whitelistFile.exists()) {
            this.saveResource("whitelist.yml", false);
        }
        this.whitelistConfig = YamlConfiguration.loadConfiguration((File)this.whitelistFile);
        this.whitelistedIPs = new HashSet<String>(this.whitelistConfig.getStringList("ips"));
    }

    private void saveWhitelist() {
        this.whitelistConfig.set("ips", new ArrayList<String>(this.whitelistedIPs));
        try {
            this.whitelistConfig.save(this.whitelistFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @EventHandler
    public void onPlayerLogin(PlayerLoginEvent event) {
        if (!this.whitelistEnabled) {
            return;
        }
        String ip = event.getAddress().getHostAddress();
        if (!this.whitelistedIPs.contains(ip)) {
            event.disallow(PlayerLoginEvent.Result.KICK_WHITELIST, this.kickMessage);
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Usage: /ipwhitelist <add|remove|list|on|off|reload> [IP]");
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "add": {
                if (args.length != 2) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /ipwhitelist add <IP>");
                    return true;
                }
                this.whitelistedIPs.add(args[1]);
                this.saveWhitelist();
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "IP added to whitelist: " + args[1]);
                break;
            }
            case "remove": {
                if (args.length != 2) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /ipwhitelist remove <IP>");
                    return true;
                }
                if (this.whitelistedIPs.remove(args[1])) {
                    this.saveWhitelist();
                    sender.sendMessage(String.valueOf(ChatColor.GREEN) + "IP removed from whitelist: " + args[1]);
                    break;
                }
                sender.sendMessage(String.valueOf(ChatColor.RED) + "IP not found in whitelist: " + args[1]);
                break;
            }
            case "list": {
                sender.sendMessage(String.valueOf(ChatColor.AQUA) + "Whitelisted IPs:");
                for (String ip : this.whitelistedIPs) {
                    sender.sendMessage(" - " + ip);
                }
                break;
            }
            case "on": {
                this.whitelistEnabled = true;
                this.getConfig().set("whitelist-enabled", (Object)true);
                this.saveConfig();
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "IP Whitelist enabled.");
                break;
            }
            case "off": {
                this.whitelistEnabled = false;
                this.getConfig().set("whitelist-enabled", (Object)false);
                this.saveConfig();
                sender.sendMessage(String.valueOf(ChatColor.RED) + "IP Whitelist disabled.");
                break;
            }
            case "reload": {
                this.reloadConfig();
                this.loadConfigValues();
                this.loadWhitelist();
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "IP Whitelist reloaded.");
                break;
            }
            default: {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Unknown subcommand.");
            }
        }
        return true;
    }
}

