/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.reward.command;

import cn.handyplus.reward.constants.PlayerTabListEnum;
import cn.handyplus.reward.constants.TabListEnum;
import cn.handyplus.reward.lib.annotation.HandyCommand;
import cn.handyplus.reward.lib.command.HandyCommandWrapper;
import cn.handyplus.reward.lib.constants.BaseConstants;
import cn.handyplus.reward.lib.util.BaseUtil;
import cn.handyplus.reward.lib.util.MessageUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;

@HandyCommand(name="playerRewards")
public class PlayerRewardsCommand
implements TabExecutor {
    private static final String PERMISSION = "playerRewards.reload";

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String label, @NotNull String[] args) {
        if (args.length < 1) {
            this.sendHelp(sender);
            return true;
        }
        boolean rst = HandyCommandWrapper.onCommand(sender, cmd, label, args, BaseUtil.getMsgNotColor("noPermission"));
        if (!rst) {
            this.sendHelp(sender);
            return true;
        }
        return true;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String label, @NotNull String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        List<String> commands = sender.hasPermission(PERMISSION) ? TabListEnum.returnList(args, args.length) : PlayerTabListEnum.returnList(args, args.length);
        if (commands == null) {
            return null;
        }
        StringUtil.copyPartialMatches((String)args[args.length - 1].toLowerCase(), commands, completions);
        Collections.sort(completions);
        return completions;
    }

    private void sendHelp(CommandSender sender) {
        if (!sender.hasPermission(PERMISSION)) {
            List playerHelps = BaseConstants.LANG_CONFIG.getStringList("playerHelps");
            for (String help : playerHelps) {
                MessageUtil.sendMessage(sender, BaseUtil.replaceChatColor(help));
            }
            return;
        }
        List helps = BaseConstants.LANG_CONFIG.getStringList("helps");
        for (String help : helps) {
            MessageUtil.sendMessage(sender, help);
        }
    }
}

