/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.reward.command.admin;

import cn.handyplus.reward.constants.RewardType;
import cn.handyplus.reward.enter.PlayerRewardsEnter;
import cn.handyplus.reward.lib.command.IHandyCommandEvent;
import cn.handyplus.reward.lib.core.StrUtil;
import cn.handyplus.reward.lib.util.AssertUtil;
import cn.handyplus.reward.lib.util.BaseUtil;
import cn.handyplus.reward.lib.util.ItemStackUtil;
import cn.handyplus.reward.lib.util.MessageUtil;
import cn.handyplus.reward.service.PlayerRewardsService;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class AddRewardCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "addReward";
    }

    @Override
    public String permission() {
        return "playerRewards.addReward";
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        boolean rst;
        AssertUtil.notTrue(args.length < 3, BaseUtil.getMsgNotColor("paramFailureMsg"));
        PlayerRewardsEnter taskRewards = new PlayerRewardsEnter();
        RewardType type = RewardType.getType(args[1]);
        taskRewards.setType(type.getRewardType());
        if (!"command".equals(type.getRewardType()) && !"console".equals(type.getRewardType())) {
            int amount = AssertUtil.isNumericToInt(args[2], BaseUtil.getMsgNotColor("amountFailureMsg"));
            taskRewards.setAmount(amount);
        }
        if ("itemStack".equals(type.getRewardType())) {
            Player player = AssertUtil.notPlayer(sender, BaseUtil.getMsgNotColor("noPlayerFailureMsg"));
            ItemStack itemInMainHand = ItemStackUtil.getItemInMainHand(player.getInventory());
            AssertUtil.notTrue(Material.AIR.equals((Object)itemInMainHand.getType()), BaseUtil.getMsgNotColor("noAir"));
            ItemStack clone = itemInMainHand.clone();
            clone.setAmount(1);
            taskRewards.setItemStack(ItemStackUtil.itemStackSerialize(clone));
        }
        if ("command".equals(type.getRewardType()) || "console".equals(type.getRewardType())) {
            AssertUtil.notTrue(args.length < 4, BaseUtil.getMsgNotColor("paramFailureMsg"));
            taskRewards.setAmount(1);
            taskRewards.setItemStack(StrUtil.replaceSpace(args[2]));
            taskRewards.setDescription(args[3]);
        }
        MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor((rst = PlayerRewardsService.getInstance().add(taskRewards)) ? "succeedMsg" : "failureMsg"));
    }
}

