/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.reward.command.admin;

import cn.handyplus.reward.constants.PluginConstants;
import cn.handyplus.reward.enter.ActivationCodeEnter;
import cn.handyplus.reward.inventory.CreateRewardsGui;
import cn.handyplus.reward.lib.command.IHandyCommandEvent;
import cn.handyplus.reward.lib.core.DateUtil;
import cn.handyplus.reward.lib.expand.adapter.HandySchedulerUtil;
import cn.handyplus.reward.lib.util.AssertUtil;
import cn.handyplus.reward.lib.util.BaseUtil;
import cn.handyplus.reward.lib.util.MessageUtil;
import cn.handyplus.reward.service.ActivationCodeService;
import java.util.Optional;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public class CreateCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "create";
    }

    @Override
    public String permission() {
        return "playerRewards.create";
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        AssertUtil.notTrue(args.length < 4, BaseUtil.getMsgNotColor("paramFailureMsg"));
        Player player = AssertUtil.notPlayer(sender, BaseUtil.getMsgNotColor("noPlayerFailureMsg"));
        String cdk = args[1];
        Integer number = AssertUtil.isNumericToInt(args[2], BaseUtil.getMsgNotColor("amountFailureMsg"));
        Integer day = AssertUtil.isNumericToInt(args[3], BaseUtil.getMsgNotColor("amountFailureMsg"));
        Optional<ActivationCodeEnter> cdkEnterOpt = ActivationCodeService.getInstance().selectByCdk(cdk);
        if (cdkEnterOpt.isPresent()) {
            MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("repetition"));
            return;
        }
        ActivationCodeEnter enter = new ActivationCodeEnter();
        enter.setCdk(cdk);
        enter.setNumber(number);
        enter.setCreateNumber(1);
        enter.setExpirationTime(DateUtil.getDate(day != 0 ? day : 36500));
        enter.setPermission(args.length > 4 ? args[4] : null);
        PluginConstants.CKD_MAP.put(player.getUniqueId(), enter);
        Inventory inventory = CreateRewardsGui.getInstance().createGui(player);
        HandySchedulerUtil.runTask(() -> player.openInventory(inventory));
    }
}

