/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.reward.command.admin;

import cn.handyplus.reward.constants.PluginConstants;
import cn.handyplus.reward.enter.GiftRewardsEnter;
import cn.handyplus.reward.inventory.CreateRewardsGui;
import cn.handyplus.reward.lib.command.IHandyCommandEvent;
import cn.handyplus.reward.lib.expand.adapter.HandySchedulerUtil;
import cn.handyplus.reward.lib.util.AssertUtil;
import cn.handyplus.reward.lib.util.BaseUtil;
import cn.handyplus.reward.lib.util.ItemStackUtil;
import cn.handyplus.reward.lib.util.MessageUtil;
import cn.handyplus.reward.service.GiftRewardsService;
import cn.handyplus.reward.util.RewardsUtil;
import java.util.Optional;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class CreateGiftCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "createGift";
    }

    @Override
    public String permission() {
        return "playerRewards.createGift";
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        GiftRewardsEnter enter;
        Player player;
        AssertUtil.notTrue(args.length < 2, BaseUtil.getMsgNotColor("paramFailureMsg"));
        if (args.length > 3) {
            String playerName = args[3];
            Optional<Player> onlinePlayer = BaseUtil.getOnlinePlayer(playerName);
            AssertUtil.isTrue(onlinePlayer.isPresent(), BaseUtil.getMsgNotColor("noPlayerFailureMsg"));
            player = onlinePlayer.get();
        } else {
            player = AssertUtil.notPlayer(sender, BaseUtil.getMsgNotColor("noPlayerFailureMsg"));
        }
        if (args.length > 2) {
            enter = new GiftRewardsEnter();
            enter.setGiftName(args[1]);
            enter.setRewards(args[2]);
            int giftId = GiftRewardsService.getInstance().add(enter);
            enter.setId(giftId);
            ItemStack itemStack = RewardsUtil.createGiftItemStack(enter);
            ItemStackUtil.addItem(player, itemStack, itemStack.getAmount());
            MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("giftSucceedMsg"));
            return;
        }
        enter = new GiftRewardsEnter();
        enter.setGiftName(args[1]);
        PluginConstants.GIFT_MAP.put(player.getUniqueId(), enter);
        Inventory inventory = CreateRewardsGui.getInstance().createGui(player);
        HandySchedulerUtil.runTask(() -> player.openInventory(inventory));
    }
}

