/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.reward.constants;

import cn.handyplus.reward.PlayerRewards;
import cn.handyplus.reward.lib.util.BaseUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class RewardType {
    public static final String VAULT = "vault";
    public static final String PLAYER_POINTS = "playerPoints";
    public static final String ITEM_STACK = "itemStack";
    public static final String COMMAND = "command";
    public static final String CONSOLE = "console";
    private static Map<String, RewardType> REWARD_TYPE_MAP = new LinkedHashMap<String, RewardType>();
    private String rewardType;
    private String rewardTypeName;
    private String pluginName;

    public static void init() {
        String pluginName = PlayerRewards.INSTANCE.getName();
        REWARD_TYPE_MAP.put(VAULT, RewardType.builder().rewardType(VAULT).rewardTypeName(BaseUtil.getLangMsg("reward.vault")).pluginName(pluginName).build());
        REWARD_TYPE_MAP.put(PLAYER_POINTS, RewardType.builder().rewardType(PLAYER_POINTS).rewardTypeName(BaseUtil.getLangMsg("reward.playerPoints")).pluginName(pluginName).build());
        REWARD_TYPE_MAP.put(ITEM_STACK, RewardType.builder().rewardType(ITEM_STACK).rewardTypeName(BaseUtil.getLangMsg("reward.itemStack")).pluginName(pluginName).build());
        REWARD_TYPE_MAP.put(COMMAND, RewardType.builder().rewardType(COMMAND).rewardTypeName(BaseUtil.getLangMsg("reward.command")).pluginName(pluginName).build());
        REWARD_TYPE_MAP.put(CONSOLE, RewardType.builder().rewardType(CONSOLE).rewardTypeName(BaseUtil.getLangMsg("reward.console")).pluginName(pluginName).build());
    }

    public static List<String> getRewardTypeList() {
        return new ArrayList<String>(REWARD_TYPE_MAP.keySet());
    }

    public static Map<String, RewardType> getRewardTypeMap() {
        return REWARD_TYPE_MAP;
    }

    public static void put(String rewardType, String rewardTypeName, String pluginName) {
        RewardType type = RewardType.builder().rewardType(rewardType).rewardTypeName(rewardTypeName).pluginName(pluginName).build();
        REWARD_TYPE_MAP.put(rewardType, type);
    }

    public static String getTypeName(String rewardType) {
        RewardType type = REWARD_TYPE_MAP.get(rewardType);
        return type != null ? type.getRewardTypeName() : "&a\u65e0";
    }

    public static RewardType getType(String rewardTypeStr) {
        for (String buyType : REWARD_TYPE_MAP.keySet()) {
            RewardType type = REWARD_TYPE_MAP.get(buyType);
            if (!type.getRewardType().equals(rewardTypeStr)) continue;
            return type;
        }
        throw new RuntimeException("\u9519\u8bef\u7684\u7c7b\u578b:" + rewardTypeStr);
    }

    public static void remove(String buyType) {
        REWARD_TYPE_MAP.remove(buyType);
    }

    @Generated
    RewardType(String rewardType, String rewardTypeName, String pluginName) {
        this.rewardType = rewardType;
        this.rewardTypeName = rewardTypeName;
        this.pluginName = pluginName;
    }

    @Generated
    public static RewardTypeBuilder builder() {
        return new RewardTypeBuilder();
    }

    @Generated
    public String getRewardType() {
        return this.rewardType;
    }

    @Generated
    public String getRewardTypeName() {
        return this.rewardTypeName;
    }

    @Generated
    public String getPluginName() {
        return this.pluginName;
    }

    static {
        RewardType.init();
    }

    @Generated
    public static class RewardTypeBuilder {
        @Generated
        private String rewardType;
        @Generated
        private String rewardTypeName;
        @Generated
        private String pluginName;

        @Generated
        RewardTypeBuilder() {
        }

        @Generated
        public RewardTypeBuilder rewardType(String rewardType) {
            this.rewardType = rewardType;
            return this;
        }

        @Generated
        public RewardTypeBuilder rewardTypeName(String rewardTypeName) {
            this.rewardTypeName = rewardTypeName;
            return this;
        }

        @Generated
        public RewardTypeBuilder pluginName(String pluginName) {
            this.pluginName = pluginName;
            return this;
        }

        @Generated
        public RewardType build() {
            return new RewardType(this.rewardType, this.rewardTypeName, this.pluginName);
        }

        @Generated
        public String toString() {
            return "RewardType.RewardTypeBuilder(rewardType=" + this.rewardType + ", rewardTypeName=" + this.rewardTypeName + ", pluginName=" + this.pluginName + ")";
        }
    }
}

