/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.reward.inventory;

import cn.handyplus.reward.constants.GuiTypeEnum;
import cn.handyplus.reward.constants.PluginConstants;
import cn.handyplus.reward.constants.RewardType;
import cn.handyplus.reward.enter.ActivationCodeEnter;
import cn.handyplus.reward.enter.GiftRewardsEnter;
import cn.handyplus.reward.enter.PlayerRewardsEnter;
import cn.handyplus.reward.lib.core.CollUtil;
import cn.handyplus.reward.lib.core.StrUtil;
import cn.handyplus.reward.lib.db.Page;
import cn.handyplus.reward.lib.inventory.HandyInventory;
import cn.handyplus.reward.lib.inventory.HandyInventoryUtil;
import cn.handyplus.reward.lib.util.BaseUtil;
import cn.handyplus.reward.lib.util.ItemMetaUtil;
import cn.handyplus.reward.lib.util.ItemStackUtil;
import cn.handyplus.reward.service.PlayerRewardsService;
import cn.handyplus.reward.util.ConfigUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class CreateRewardsGui {
    private static final CreateRewardsGui INSTANCE = new CreateRewardsGui();

    private CreateRewardsGui() {
    }

    public static CreateRewardsGui getInstance() {
        return INSTANCE;
    }

    public Inventory createGui(Player player) {
        String title = ConfigUtil.REWARD_CONFIG.getString("title");
        int size = ConfigUtil.REWARD_CONFIG.getInt("size", 54);
        String sound = ConfigUtil.REWARD_CONFIG.getString("sound");
        HandyInventory handyInventory = new HandyInventory(GuiTypeEnum.CREATE_REWARDS.getType(), title, size, sound);
        handyInventory.setPlayer(player);
        this.setInventoryDate(handyInventory);
        return handyInventory.getInventory();
    }

    public void setInventoryDate(HandyInventory handyInventory) {
        handyInventory.setGuiType(GuiTypeEnum.CREATE_REWARDS.getType());
        HandyInventoryUtil.refreshInventory(handyInventory.getInventory());
        this.setDate(handyInventory);
        this.setFunctionMenu(handyInventory);
    }

    public void setDate(HandyInventory handyInventory) {
        Inventory inv = handyInventory.getInventory();
        Integer pageNum = handyInventory.getPageNum();
        Player player = handyInventory.getPlayer();
        String searchType = handyInventory.getSearchType();
        Map<Integer, Integer> map = handyInventory.getIntMap();
        handyInventory.setPageSize(45);
        Page<PlayerRewardsEnter> rewardsEnterPage = PlayerRewardsService.getInstance().selectPageByType(searchType, pageNum, handyInventory.getPageSize());
        handyInventory.setPageCount(rewardsEnterPage.getTotal());
        List<PlayerRewardsEnter> rewardList = rewardsEnterPage.getRecords();
        if (CollUtil.isEmpty(rewardList)) {
            return;
        }
        block13: for (int i = 0; i < rewardList.size(); ++i) {
            GiftRewardsEnter giftRewardsEnter;
            ItemStack itemStack;
            PlayerRewardsEnter enter = rewardList.get(i);
            String displayName = "";
            switch (enter.getType()) {
                case "vault": {
                    itemStack = new ItemStack(Material.GOLD_INGOT);
                    break;
                }
                case "playerPoints": {
                    itemStack = new ItemStack(Material.DIAMOND);
                    break;
                }
                case "itemStack": {
                    itemStack = ItemStackUtil.itemStackDeserialize(enter.getItemStack());
                    displayName = BaseUtil.getDisplayName(itemStack);
                    break;
                }
                case "command": 
                case "console": {
                    itemStack = new ItemStack(Material.NAME_TAG);
                    break;
                }
                default: {
                    continue block13;
                }
            }
            ItemMeta itemMeta = Objects.requireNonNull(itemStack.getItemMeta());
            itemMeta.setDisplayName(BaseUtil.getLangMsg("rewardName") + enter.getId());
            ArrayList<String> loreList = new ArrayList<String>();
            String lore = RewardType.getTypeName(enter.getType()) + " " + enter.getAmount() + " " + displayName;
            if ("command".equals(enter.getType()) || "console".equals(enter.getType())) {
                lore = RewardType.getTypeName(enter.getType()) + " " + enter.getItemStack().replace("${player}", player.getName());
                loreList.add(lore);
                loreList.add("&a\u63cf\u8ff0 " + (StrUtil.isNotEmpty(enter.getDescription()) ? enter.getDescription() : ""));
            } else {
                loreList.add(lore);
            }
            ActivationCodeEnter cdkEnter = PluginConstants.CKD_MAP.get(player.getUniqueId());
            if (cdkEnter != null && StrUtil.isNotEmpty(cdkEnter.getRewards())) {
                List<Long> rewardsIds = StrUtil.strToLongList(cdkEnter.getRewards());
                for (Long rewardsId : rewardsIds) {
                    if (!rewardsId.equals(enter.getId().longValue())) continue;
                    ItemMetaUtil.setEnchant(itemMeta);
                    loreList.add(BaseUtil.getLangMsg("selected"));
                }
            }
            if ((giftRewardsEnter = PluginConstants.GIFT_MAP.get(player.getUniqueId())) != null && StrUtil.isNotEmpty(giftRewardsEnter.getRewards())) {
                List<Long> rewardsIds = StrUtil.strToLongList(giftRewardsEnter.getRewards());
                for (Long rewardsId : rewardsIds) {
                    if (!rewardsId.equals(enter.getId().longValue())) continue;
                    ItemMetaUtil.setEnchant(itemMeta);
                    loreList.add(BaseUtil.getLangMsg("selected"));
                }
            }
            itemMeta.setLore(BaseUtil.replaceChatColor(loreList));
            itemStack.setItemMeta(itemMeta);
            inv.setItem(i, itemStack);
            map.put(i, enter.getId());
        }
    }

    private void setFunctionMenu(HandyInventory handyInventory) {
        Map<String, String> replacePageMap = HandyInventoryUtil.replacePageMap(handyInventory);
        HandyInventoryUtil.setButton(ConfigUtil.REWARD_CONFIG, handyInventory, "nextPage", replacePageMap);
        HandyInventoryUtil.setButton(ConfigUtil.REWARD_CONFIG, handyInventory, "previousPage", replacePageMap);
        HandyInventoryUtil.setButton(ConfigUtil.REWARD_CONFIG, handyInventory, "step", replacePageMap);
    }
}

