/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.reward.inventory;

import cn.handyplus.reward.constants.GuiTypeEnum;
import cn.handyplus.reward.constants.RewardType;
import cn.handyplus.reward.enter.PlayerRewardsEnter;
import cn.handyplus.reward.lib.core.CollUtil;
import cn.handyplus.reward.lib.core.StrUtil;
import cn.handyplus.reward.lib.db.Page;
import cn.handyplus.reward.lib.inventory.HandyInventory;
import cn.handyplus.reward.lib.inventory.HandyInventoryUtil;
import cn.handyplus.reward.lib.util.BaseUtil;
import cn.handyplus.reward.lib.util.ItemStackUtil;
import cn.handyplus.reward.service.PlayerRewardsService;
import cn.handyplus.reward.util.ConfigUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ViewRewardsGui {
    private static final ViewRewardsGui INSTANCE = new ViewRewardsGui();

    private ViewRewardsGui() {
    }

    public static ViewRewardsGui getInstance() {
        return INSTANCE;
    }

    public Inventory createGui(Player player) {
        String title = ConfigUtil.REWARD_CONFIG.getString("viewTitle");
        HandyInventory handyInventory = new HandyInventory(GuiTypeEnum.VIEW_REWARDS.getType(), title);
        handyInventory.setPlayer(player);
        this.setInventoryDate(handyInventory);
        return handyInventory.getInventory();
    }

    public void setInventoryDate(HandyInventory handyInventory) {
        handyInventory.setGuiType(GuiTypeEnum.VIEW_REWARDS.getType());
        handyInventory.setSearchType(handyInventory.getSearchType());
        HandyInventoryUtil.refreshInventory(handyInventory.getInventory());
        this.setDate(handyInventory);
        this.setFunctionMenu(handyInventory);
    }

    public void setDate(HandyInventory handyInventory) {
        String searchType = handyInventory.getSearchType();
        Inventory inv = handyInventory.getInventory();
        Map<Integer, Integer> map = handyInventory.getIntMap();
        Integer pageNum = handyInventory.getPageNum();
        handyInventory.setPageSize(45);
        Page<PlayerRewardsEnter> rewardsEnterPage = PlayerRewardsService.getInstance().selectPageByType(searchType, pageNum, handyInventory.getPageSize());
        handyInventory.setPageCount(rewardsEnterPage.getTotal());
        List<PlayerRewardsEnter> rewardList = rewardsEnterPage.getRecords();
        if (CollUtil.isEmpty(rewardList)) {
            return;
        }
        block13: for (int i = 0; i < rewardList.size(); ++i) {
            ItemStack itemStack;
            PlayerRewardsEnter enter = rewardList.get(i);
            String displayName = "";
            switch (enter.getType()) {
                case "vault": {
                    itemStack = new ItemStack(Material.GOLD_INGOT);
                    break;
                }
                case "playerPoints": {
                    itemStack = new ItemStack(Material.DIAMOND);
                    break;
                }
                case "command": 
                case "console": {
                    itemStack = new ItemStack(Material.NAME_TAG);
                    break;
                }
                case "itemStack": {
                    itemStack = ItemStackUtil.itemStackDeserialize(enter.getItemStack());
                    if (itemStack.getItemMeta() == null) break;
                    displayName = BaseUtil.getDisplayName(itemStack);
                    break;
                }
                default: {
                    continue block13;
                }
            }
            ItemMeta itemMeta = itemStack.getItemMeta();
            if (itemMeta != null) {
                itemMeta.setDisplayName(BaseUtil.getLangMsg("rewardName") + enter.getId());
                ArrayList<String> loreList = new ArrayList<String>();
                String lore = RewardType.getTypeName(enter.getType()) + " " + enter.getAmount() + " " + displayName;
                if ("command".equals(enter.getType()) || "console".equals(enter.getType())) {
                    lore = RewardType.getTypeName(enter.getType()) + " " + enter.getItemStack();
                    loreList.add(lore);
                    loreList.add("&a\u63cf\u8ff0 " + (StrUtil.isNotEmpty(enter.getDescription()) ? enter.getDescription() : ""));
                } else {
                    loreList.add(lore);
                }
                loreList.add(BaseUtil.getLangMsg("button"));
                itemMeta.setLore(BaseUtil.replaceChatColor(loreList));
                itemStack.setItemMeta(itemMeta);
            }
            inv.setItem(i, itemStack);
            map.put(i, enter.getId());
        }
    }

    private void setFunctionMenu(HandyInventory handyInventory) {
        Map<String, String> replacePageMap = HandyInventoryUtil.replacePageMap(handyInventory);
        HandyInventoryUtil.setButton(ConfigUtil.REWARD_CONFIG, handyInventory, "nextPage", replacePageMap);
        HandyInventoryUtil.setButton(ConfigUtil.REWARD_CONFIG, handyInventory, "previousPage", replacePageMap);
    }
}

